package com.infoepoch.pms.dispatchassistant.common.utils;

public class StringTool {

    /**
     * 查询单个字符数量
     *
     * @param str
     * @param regex
     * @return
     */
    public static int searchCharCount(String str, char regex) {
        char[] chars = str == null ? new char[0] : str.toCharArray();
        int count = 0;
        for (char c : chars) {
            if (c == regex) {
                count++;
            }
        }
        return count;
    }

    /**
     * 获取字符串
     *
     * @param integer
     * @return
     */
    public static String getString(Integer integer) {
        if (integer == null)
            return null;
        else
            return String.valueOf(integer);
    }

    /**
     * 获取字符串
     *
     * @param o
     * @return
     */
    public static String getString(Object o) {
        if (o == null)
            return null;
        else
            return String.valueOf(o);
    }

    /**
     * @param o
     * @param defaultString
     * @return
     */
    public static String getString(Object o, String defaultString) {
        try {
            return String.valueOf(o);
        } catch (Exception e) {
            return defaultString;
        }
    }

    /**
     * @param str
     * @param defaultStr
     * @return
     */
    public static String getString(String str, String defaultStr) {
        if (str == null || str.equals("") || str.equals("null")) {
            return defaultStr;
        } else {
            return str;
        }
    }

    /**
     * 填充字符串左侧0
     *
     * @param num
     * @param targetLength
     * @return
     */
    public static String fillLeftZero(Integer num, int targetLength) {
        StringBuilder numStr = new StringBuilder(String.valueOf(num));
        int length = numStr.length();
        if (length >= targetLength) {
            return numStr.toString();
        } else {
            for (int i = 0; i < targetLength - length; i++) {
                numStr.insert(0, "0");
            }
            return numStr.toString();
        }
    }

    /**
     * 移除字符串中的html标签
     *
     * @param str
     * @return
     */
    public static String removeHtmlTag(String str) {
        String htmlRegex = "<[^>]+>";
        return str.replaceAll(htmlRegex, "")
                .replaceAll("&gt;", "“")// 大于
                .replaceAll("&lt;", "“")// 小于
                .replaceAll("&amp;", "“")// AND符号
                .replaceAll("&quot;", "“")// 双引号
                .replaceAll("&ldquo;", "“")// 左双引号
                .replaceAll("&rdquo;", "”")// 右双引号
                .replaceAll("&nbsp;", " ")// 空格
                ;
    }

    /**
     * 编码自增
     *
     * @param str
     * @param length
     * @return
     */
    public static String increase(String str, int length) {
        int old = Integer.parseInt(str);
        return fillLeftZero(old + 1, length);
    }

}
