package com.infoepoch.pms.dispatchassistant.common.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

/**
 * @author guoshun
 * @description: 调用摩卡短信接口发送短信：新版掌上工程获取短信验证码在用
 * @date 2022/3/1016:46
 */
@Component
public class MessageUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(MessageUtil.class);
    public static boolean send(String messageIp, int messagePort, String messagePass,
                                String messageSender, String messageReveiver, String messageContent) {
        boolean bool = false;
        DataOutputStream out = null;
        Socket clientSocket = null;
        try {
            byte tmpPhone[] = messageReveiver.getBytes();
            byte tmpMsg[] = messageContent.getBytes("GB2312");
            byte tmppass[] = messagePass.getBytes();
            if (messageSender == null || messageSender.equals("")) {

                byte submit_packet[] = new byte[tmppass.length
                        + tmpPhone.length + tmpMsg.length + 3];
                int i;
                for (i = 0; i < tmppass.length; i++) {
                    submit_packet[i] = tmppass[i];
                }
                submit_packet[i] = 0;
                for (i = 0; i < tmpPhone.length; i++) {
                    submit_packet[i + tmppass.length + 1] = tmpPhone[i];
                }
                submit_packet[i + tmppass.length + 1] = 0;

                for (i = 0; i < tmpMsg.length; i++) {
                    submit_packet[i + tmppass.length + tmpPhone.length + 2] = tmpMsg[i];
                }
                submit_packet[i + tmppass.length + tmpPhone.length + 2] = 0;
                clientSocket = new Socket(messageIp, messagePort);
                out = new DataOutputStream(clientSocket.getOutputStream());
                int bufSize = 8 + submit_packet.length;
                int series = 99;
                int smid = 99;
                int message_type = 0;
                out.writeInt(series);
                out.writeInt(bufSize);
                out.writeInt(message_type);
                out.writeInt(smid);
                out.write(submit_packet, 0, submit_packet.length);
                out.flush();
                bool = true;
            } else {
                StringBuilder request = new StringBuilder();
                request.append("<xml><passwd>").append(messagePass)
                        .append("</passwd><phone>").append(messageReveiver)
                        .append("</phone><msg>").append(messageContent)
                        .append("</msg><spCode>").append(messageSender)
                        .append("</spCode></xml>");
                byte submit_packet[] = request.toString().getBytes("GB2312");
                int bufSize = 8 + submit_packet.length;
                int series = 99;
                int smid = 99;
                int message_type = 16;
                clientSocket = new Socket(messageIp, messagePort);
                out = new DataOutputStream(clientSocket.getOutputStream());
                out.writeInt(series);
                out.writeInt(bufSize);
                out.writeInt(message_type);
                out.writeInt(smid);
                out.write(submit_packet, 0, submit_packet.length);
                out.flush();
                bool = true;
                LOGGER.info("send message success");

            }
            return bool;
        } catch (Exception e) {
            LOGGER.info("send message error:"+e);
            return false;
        } finally {
            if(null != out) {
                try {
                    out.close();
                    out = null;
                } catch (IOException e) {}
            }
            if(null != clientSocket) {
                try {
                    clientSocket.close();
                    clientSocket = null;
                } catch (IOException e) {}
            }
        }
    }

}
