package com.infoepoch.pms.dispatchassistant.common.utils;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

/**
 * 集合工具类
 */
public class ListUtils {

    /**
     * 字符串拆分为List<Integer>
     */
    public static List<Integer> splitInteger(String str, String regex) {
        if (StringUtils.isBlank(str))
            return new ArrayList<>();
        return Arrays.stream(str.split(regex))
                .filter(s -> !StringUtils.isBlank(s))
                .map(s -> Integer.parseInt(s.trim()))
                .collect(Collectors.toList());
    }

    /**
     * 字符串拆分为List<Long>
     */
    public static List<Long> splitLong(String str, String regex) {
        if (StringUtils.isBlank(str))
            return new ArrayList<>();
        return Arrays.stream(str.split(regex))
                .filter(s -> !StringUtils.isBlank(s))
                .map(s -> Long.parseLong(s.trim()))
                .collect(Collectors.toList());
    }

    /**
     * 字符串拆分为List<String>
     */
    public static List<String> splitString(String str, String regex) {
        if (StringUtils.isBlank(str))
            return new ArrayList<>();
        return Arrays.stream(str.split(regex))
                .filter(s -> !StringUtils.isBlank(s))
                .map(String::trim)
                .collect(Collectors.toList());
    }

    //-------------------------------------------------------------------------

    /**
     * 集合转成String字符串
     *
     * @param arrayList
     * @param flag
     * @return
     */
    public static String integerJoin(List<Integer> arrayList, Boolean flag) {
        if (arrayList == null || arrayList.isEmpty())
            return "";
        if (flag) {
            return arrayList.stream().map(s -> String.valueOf(s)).collect(Collectors.joining(",", ",", ","));
        } else {
            return StringUtils.join(arrayList, ",");
        }
    }

    /**
     * 集合转成String 字符串
     *
     * @param arrayList
     * @return
     */
    public static String integerJoin(List<Integer> arrayList) {
        if (arrayList == null || arrayList.isEmpty())
            return "";
        return arrayList.stream().map(s -> String.valueOf(s)).collect(Collectors.joining(",", ",", ","));
    }

    /**
     * 集合转成String 字符串
     *
     * @param arrayList
     * @param flag
     * @return
     */
    public static String longJoin(List<Long> arrayList, Boolean flag) {
        if (arrayList == null || arrayList.isEmpty())
            return "";
        if (flag) {
            return arrayList.stream().map(s -> String.valueOf(s)).collect(Collectors.joining(",", ",", ","));
        } else {
            return StringUtils.join(arrayList, ",");
        }
    }


    /**
     * 集合转成String 字符串
     *
     * @param arrayList
     * @return
     */
    public static String longJoin(List<Long> arrayList) {
        if (arrayList == null || arrayList.isEmpty())
            return "";
        return arrayList.stream().map(s -> String.valueOf(s)).collect(Collectors.joining(",", ",", ","));
    }

    /**
     * 集合转成String 字符串
     *
     * @param arrayList
     * @param flag
     * @return
     */
    public static String join(List<String> arrayList, Boolean flag) {
        if (arrayList == null || arrayList.isEmpty())
            return "";
        if (flag) {
            return arrayList.stream().collect(Collectors.joining(",", ",", ","));
        } else {
            return StringUtils.join(arrayList, ",");
        }
    }

    /**
     * 集合转成String 字符串
     *
     * @param arrayList
     * @param flag
     * @return
     */
    public static String join(List<String> arrayList, String separator, Boolean flag) {
        if (arrayList == null || arrayList.isEmpty())
            return "";
        if (flag) {
            return arrayList.stream().collect(Collectors.joining(separator, separator, separator));
        } else {
            return StringUtils.join(arrayList, separator);
        }
    }

    /**
     * 集合转成String 字符串
     *
     * @param arrayList
     * @return
     */
    public static String join(List<String> arrayList) {
        if (arrayList == null || arrayList.isEmpty())
            return "";
        return arrayList.stream().collect(Collectors.joining(",", ",", ","));
    }

    //-------------------------------------------------------------------------

    /**
     * 将 object 类型转换为 List<T> 类型
     *
     * @param object object对象
     * @param <T>    目标集合类型
     */
    public static <T> List<T> transformObjectToList(Object object, Class<T> clazz) {
        List<T> list = new ArrayList<T>();
        if (object instanceof List<?>) {
            for (Object obj : (List<?>) object)
                list.add(clazz.cast(obj));
        }
        return list;
    }

    /**
     * 计算集合中所有连续的相同数据的 《起，始》 下标
     */
    public static Map<Integer, Integer> getSameDataSubscriptByList(List<String> list) {
        String sameFlag = null;
        int pointer = 0;
        Map<Integer, Integer> indexMap = new HashMap<>();
        for (int i = 0, length = list.size(); i < length; i++) {
            String curData = list.get(i);
            // 如果当前数据和标记数据不相等
            if (!curData.equalsIgnoreCase(sameFlag)) {
                sameFlag = curData;
                if (i != 0 && pointer != i - 1) {
                    indexMap.put(pointer, i - 1);
                }
                pointer = i;
            } else {
                if (i == length - 1) {
                    indexMap.put(pointer, i);
                }
            }
        }
        return indexMap;
    }

    /**
     * 计算集合中所有连续的相同数据的 《始，起》 下标
     */
    public static Map<Integer, Integer> getSameDataSubscriptByListReverse(List<String> list) {
        String sameFlag = null;
        int pointer = 0;
        Map<Integer, Integer> indexMap = new HashMap<>();
        for (int i = 0, length = list.size(); i < length; i++) {
            String curData = list.get(i);
            // 如果当前数据和标记数据不相等
            if (!curData.equalsIgnoreCase(sameFlag)) {
                sameFlag = curData;
                if (i != 0 && pointer != i - 1) {
                    indexMap.put(i - 1, pointer);
                }
                pointer = i;
            } else {
                if (i == length - 1) {
                    indexMap.put(i, pointer);
                }
            }
        }
        return indexMap;
    }

    /**
     * 给list的集合数据去重
     */
    public static  <T,R> Predicate<T> distinctByKey(Function<T,R> keyExtractor){
        ConcurrentHashMap<R, Boolean> seen = new ConcurrentHashMap<>();
        //如果 put的key不存在则返回 null 如果 存在则返回该key对应的值
        return t -> seen.putIfAbsent(keyExtractor.apply(t),Boolean.TRUE) == null;
    }

}
