package com.infoepoch.pms.dispatchassistant.common.utils;

import org.apache.commons.collections4.CollectionUtils;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

public class LambdaTool {

    public static <T> List<T> pagingList(List<T> list, int pageIndex, int pageSize) {
        if(CollectionUtils.isEmpty(list))
            return Collections.EMPTY_LIST;
        if(pageSize <= 0)
            return Collections.EMPTY_LIST;
        if(pageIndex <= 0) {
            pageIndex = 1;
        }
        return list.stream().skip((long) pageSize * (pageIndex - 1)).limit(pageSize).collect(Collectors.toList());
    }

    /**
     * 截取字符串
     *
     * @param list
     * @param fromIndex
     * @param toIndex
     * @param function
     * @param <T>
     * @param <R>
     * @return
     */
    public static <T, R> List<R> subList(List<T> list, int fromIndex, int toIndex, Function<T, R> function) {
        List<R> resultList = new ArrayList<>();
        if (CollectionUtils.isEmpty(list)) {
            return resultList;
        }
        list = list.subList(fromIndex, toIndex);
        for (T t : list) {
            resultList.add(function.apply(t));
        }
        return resultList;
    }

    /**
     * 将列表转换成map
     * 备注：key不要存在重复的，否则会丢失部分数据
     *
     * @param collection
     * @param keyFunction
     * @param <T>
     * @param <R>
     * @return
     */
    public static <T, R> Map<T, R> changeCollectionToHashMap(Collection<R> collection, Function<R, T> keyFunction) {
        Map<T, R> resultMap = new HashMap<>();
        if (collection != null) {
            for (R r : collection) {
                resultMap.put(keyFunction.apply(r), r);
            }
        }
        return resultMap;
    }

    /**
     * 将列表转换成map
     *
     * @param collection
     * @param keyFunction
     * @param valueFunction
     * @param <T>
     * @param <K>
     * @param <V>
     * @return
     */
    public static <T, K, V> Map<K, V> changeCollectionToHashMap(Collection<T> collection, Function<T, K> keyFunction, Function<T, V> valueFunction) {
        Map<K, V> resultMap = new HashMap<>();
        if (collection != null) {
            for (T t : collection) {
                resultMap.put(keyFunction.apply(t), valueFunction.apply(t));
            }
        }
        return resultMap;
    }

    /**
     * 将列表根据key分成多个list并存入map中
     *
     * @param collection
     * @param keyFunction
     * @param <T>
     * @param <R>
     * @return
     */
    public static <T, R> Map<T, List<R>> changeCollectionToHashListMap(Collection<R> collection, Function<R, T> keyFunction) {
        Map<T, List<R>> resultMap = new HashMap<>();
        if (collection != null) {
            for (R r : collection) {
                List<R> rList = resultMap.get(keyFunction.apply(r));
                if (rList == null) {
                    rList = new ArrayList<>();
                }
                rList.add(r);
                resultMap.put(keyFunction.apply(r), rList);
            }
        }
        return resultMap;
    }

    public static <T, K, V> Map<K, List<V>> changeCollectionToHashListMap(Collection<T> collection, Function<T, K> keyFunction, Function<T, List<V>> valueFunction) {
        Map<K, List<V>> resultMap = new HashMap<>();
        if (collection != null) {
            for (T t : collection) {
                List<V> rList = resultMap.get(keyFunction.apply(t));
                if (rList == null) {
                    rList = new ArrayList<>();
                }
                rList.addAll(valueFunction.apply(t));
                resultMap.put(keyFunction.apply(t), rList);
            }
        }
        return resultMap;
    }

    /**
     * 将列表转换成另一个列表
     *
     * @param collection
     * @param function
     * @param <T>
     * @param <R>
     * @return
     */
    public static <T, R> List<R> transformCollectionToArrayList(Collection<T> collection, Function<T, R> function) {
        List<R> resultList = new ArrayList<>();
        if (collection != null) {
            for (T t : collection) {
                resultList.add(function.apply(t));
            }
        }
        return resultList;
    }

    /**
     * 将map转换成list
     *
     * @param map
     * @param function
     * @param <K>
     * @param <V>
     * @param <R>
     * @return
     */
    public static <K, V, R> List<R> transformMapToArrayList(Map<K, V> map, Function<V, R> function) {
        List<R> resultList = new ArrayList<>();
        if (map != null) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                resultList.add(function.apply(entry.getValue()));
            }
        }
        return resultList;
    }

}
