package com.infoepoch.pms.dispatchassistant.common.utils;

import org.apache.commons.lang3.StringUtils;

import java.util.List;

public class IntegerTool {

    /**
     * @param one
     * @param two
     * @return
     */
    public static int addTwoInt(Object one, Object two) {
        return getInt(one) + getInt(two);
    }

    /**
     * @param integers
     * @return
     */
    public static int getMaxInt(Integer... integers) {
        int max = 0;
        for (Integer integer : integers) {
            if (max < integer) {
                max = integer;
            }
        }
        return max;
    }

    /**
     * 获取最小值
     *
     * @param integers
     * @return
     */
    public static int getMinInt(Integer... integers) {
        Integer min = null;
        for (Integer integer : integers) {
            if (min == null) {
                min = integer;
            } else if (min > integer) {
                min = integer;
            }
        }
        if (min == null) min = 0;
        return min;
    }

    /**
     * 获取最小值
     *
     * @param integerList
     * @return
     */
    public static int getMinInt(List<Integer> integerList) {
        Integer min = null;
        for (Integer integer : integerList) {
            if (min == null) {
                min = integer;
            } else if (min > integer) {
                min = integer;
            }
        }
        if (min == null) min = 0;
        return min;
    }

    /**
     * 最大值向上取整
     *
     * @param max
     * @return
     */
    public static int maxIntRoundUp(int max) {
        String maxStr = String.valueOf(max);
        String[] arr = maxStr.split("");
        if (maxStr.length() == 1) {
            return 10;
        }
        if (maxStr.length() == 2) {
            if (Integer.parseInt(arr[0]) == 9) {
                return 100;
            } else {
                arr[0] = String.valueOf(Integer.parseInt(arr[0]) + 1);
            }
            arr[1] = String.valueOf(0);
        }
        if (maxStr.length() == 3) {
            if (Integer.parseInt(arr[1]) == 9) {
                if (Integer.parseInt(arr[0]) == 9) {
                    return 1000;
                } else {
                    arr[0] = String.valueOf(Integer.parseInt(arr[0]) + 1);
                    arr[1] = String.valueOf(0);
                }
            } else {
                arr[1] = String.valueOf(Integer.parseInt(arr[1]) + 1);
            }
            arr[2] = String.valueOf(0);
        }
        if (maxStr.length() == 4) {
            if (Integer.parseInt(arr[1]) == 9) {
                if (Integer.parseInt(arr[0]) == 9) {
                    return 100000;
                } else {
                    arr[0] = String.valueOf(Integer.parseInt(arr[0]) + 1);
                    arr[1] = String.valueOf(0);
                }
            } else {
                arr[1] = String.valueOf(Integer.parseInt(arr[1]) + 1);
            }
            arr[2] = String.valueOf(0);
            arr[3] = String.valueOf(0);
        }
        if (maxStr.length() > 4) {
            if (Integer.parseInt(arr[1]) == 9) {
                if (Integer.parseInt(arr[0]) == 9) {
                    String[] tempArr = new String[arr.length + 1];
                    tempArr[0] = String.valueOf(1);
                    for (int i = 0; i < arr.length; i++) {
                        tempArr[i + 1] = String.valueOf(0);
                    }
                    return Integer.parseInt(StringUtils.join(tempArr));
                } else {
                    arr[0] = String.valueOf(Integer.parseInt(arr[0]) + 1);
                    arr[1] = String.valueOf(0);
                }
            } else {
                arr[1] = String.valueOf(Integer.parseInt(arr[1]) + 1);
            }
            for (int i = 2; i < arr.length; i++) {
                arr[i] = String.valueOf(0);
            }
        }
        return Integer.parseInt(StringUtils.join(arr));
    }

    /**
     * 获取int
     *
     * @param o
     * @return
     */
    public static int getInt(Object o) {
        return getInt(o, 0);
    }

    /**
     * 获取int
     *
     * @param o
     * @param defaultValue
     * @return
     */
    public static int getInt(Object o, int defaultValue) {
        if (o == null)
            return defaultValue;
        if (o instanceof Integer) {
            return (int) o;
        }
        try {
            return Integer.parseInt(String.valueOf(o));
        } catch (Exception e2) {
            return defaultValue;
        }
    }

    public static int getInt(Boolean b) {
        return getInt(b, 0);
    }

    public static int getInt(Boolean b, int defaultValue) {
        if (b == null)
            return defaultValue;
        if (b) {
            return 1;
        } else {
            return 0;
        }
    }

    /**
     * 获取Integer对象
     *
     * @param str
     * @return
     */
    public static Integer getInteger(String str) {
        try {
            return Integer.parseInt(str);
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * @param str
     * @return
     */
    public static boolean isNumber(String str) {
        try {
            Double.parseDouble(str);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

}
