/*
 * Copyright (C), 2018, 江苏新纪元信息发展有限公司
 * FileName: BeanCopyUtils
 * Author: LQB
 * Date: 2018年06月25日 下午2:56:12
 * version：1.0.0
 * Description：属性转换
 */
package com.infoepoch.pms.dispatchassistant.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

/**
 * 属性拷贝
 *
 * @author LQB
 */
public class BeanCopyUtils
{

    /**
     * 属性拷贝，,不拷贝ID
     *
     * @param source
     * @param clazz
     * @return Object
     */
    public static Object copyPropertiesForClass(Object source, Class<?> clazz) throws Exception
    {
        if (source != null)
        {
            Object target = clazz.newInstance();
            copyProperties(source, target);
            return target;
        }
        return null;
    }

    /**
     * 属性拷贝  不拷贝ID,Date类型的属性
     *
     * * @param source 源对象
     * @param target 目标对象
     */
    public static void copyPropertiesToUpper(Object source, Object target)
    {
        try
        {
            Field[] fileds = target.getClass().getDeclaredFields();
            for (int i = 0; i < fileds.length; i++)
            {
                try
                {
                    String filedName = fileds[i].getName();
                    char firstWord = filedName.charAt(0);
                   String dateString=fileds[i].getType().getName();
                    if (Character.isLowerCase(firstWord)
                            && !filedName.equals("id")
                            && !filedName.equals("orgId")
                            && !filedName.equals("ou_id")
                            && !filedName.equals("hashCode")
                            && !dateString.equals("java.util.Date")
                            && !filedName.equals("updateType")
                            && !filedName.equals("updateTime")
                            && !filedName.equals("permission")
                            && !filedName.equals("reference1")
                            && !filedName.equals("attachmentfilelist")
                            && !dateString.equals("java.sql.Timestamp")
                    )
                    {

                        String setMethodName = "set" + String.valueOf(firstWord).toUpperCase() + filedName.substring(1, filedName.length());
                        String getMethodName = "get" + String.valueOf(firstWord).toUpperCase() + filedName.substring(1, filedName.length());
                        String getMethodNameUpper = "get" + filedName.toUpperCase() ;


                        Method getMethod = source.getClass().getMethod(getMethodNameUpper, new Class[]{});
                        if (getMethod != null)
                        {
                            Object getValue = getMethod.invoke(source, new Object[]{}); //get值
                            if (getValue != null && getMethod.getReturnType() != null)
                            {
                                Method setMethod = target.getClass().getMethod(setMethodName, new Class[]{getMethod.getReturnType()});
                                if (setMethod != null)
                                {
                                    setMethod.invoke(target, new Object[]{getValue});
                                }
                            }
                        }
                    }
                }
                catch (Exception e)
                {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
    }



    /**
     * 属性拷贝  不拷贝ID,Date类型的属性
     *
     * * @param source 源对象
     * @param target 目标对象
     */
    public static void copyPropertiesAddUpper(Object source, Object target)
    {
        try
        {
            Field[] fileds = target.getClass().getDeclaredFields();
            for (int i = 0; i < fileds.length; i++)
            {
                try
                {
                    String filedName = fileds[i].getName();
                    char firstWord = filedName.charAt(0);
                    String dateString=fileds[i].getType().getName();
                    if (Character.isLowerCase(firstWord)
                            && !filedName.equals("id")
                            && !filedName.equals("teamWorkKey")
                            && !filedName.equals("auditRoutePriKey")
                            && !filedName.equals("hashCode")
                            && !dateString.equals("java.util.Date")
                            && !filedName.equals("projectpmsid")
                            && !filedName.equals("projectbaseid")
                            && !filedName.equals("stationopenid")
                    )
                    {
                        String setMethodNameAdd = "set" +  filedName.toUpperCase() ;
                        String getMethodNameUpper = "get" + filedName.toUpperCase() ;


                        Method getMethod = source.getClass().getMethod(getMethodNameUpper, new Class[]{});
                        if (getMethod != null)
                        {
                            Object getValue = getMethod.invoke(source, new Object[]{}); //get值
                            if (getValue != null && getMethod.getReturnType() != null)
                            {
                                Method setMethod = target.getClass().getMethod(setMethodNameAdd, new Class[]{getMethod.getReturnType()});
                                if (setMethod != null)
                                {
                                    setMethod.invoke(target, new Object[]{getValue});
                                }
                            }
                        }
                    }
                }
                catch (Exception e)
                {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
    }
    /**
     * 属性拷贝  不拷贝ID
     *
     * @param source 源对象
     * @param target 目标对象
     */
    public static void copyProperties(Object source, Object target)
    {
        try
        {
            Field[] fileds = target.getClass().getDeclaredFields();
            for (int i = 0; i < fileds.length; i++)
            {
                try
                {
                    String filedName = fileds[i].getName();
                    char firstWord = filedName.charAt(0);
                    if (Character.isLowerCase(firstWord)
                            && !filedName.equals("id")
                            && !filedName.equals("hashCode"))
                    {

                        String setMethodName = "set" + String.valueOf(firstWord).toUpperCase() + filedName.substring(1, filedName.length());
                        String getMethodName = "get" + String.valueOf(firstWord).toUpperCase() + filedName.substring(1, filedName.length());
                        Method getMethod = source.getClass().getMethod(getMethodName, new Class[]{});
                        if (getMethod != null)
                        {
                            Object getValue = getMethod.invoke(source, new Object[]{}); //get值
                            if (getValue != null && getMethod.getReturnType() != null)
                            {
                                Method setMethod = target.getClass().getMethod(setMethodName, new Class[]{getMethod.getReturnType()});
                                if (setMethod != null)
                                {
                                    setMethod.invoke(target, new Object[]{getValue});
                                }
                            }
                        }
                    }
                }
                catch (Exception e)
                {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
    }

    /**
     * 属性拷贝(webservice)  不拷贝ID
     *
     * @param type   1:取外部webservice传进来的参数 2:本地vo拷贝进外部webservice
     * @param source 源对象
     * @param target 目标对象
     */
    public static void copyPropertiesForWebService(Object source, Object target, Integer type)
    {
        try
        {
            Field[] fileds = target.getClass().getDeclaredFields();
            for (int i = 0; i < fileds.length; i++)
            {
                try
                {
                    String filedName = fileds[i].getName();
                    char firstWord = filedName.charAt(0);
                    if (Character.isLowerCase(firstWord)
                            && !filedName.equals("id")
                            && !filedName.equals("hashCode"))
                    {
                        String setMethodName = "";
                        String getMethodName = "";
                        if (type == 1)
                        {
                            setMethodName = "set" + String.valueOf(firstWord).toUpperCase() + filedName.substring(1, filedName.length());
                            getMethodName = "get" + String.valueOf(filedName).toUpperCase();
                        }
                        else if (type == 2)
                        {
                            setMethodName = "set" + String.valueOf(filedName).toUpperCase();
                            getMethodName = "get" + String.valueOf(firstWord).toUpperCase() + filedName.substring(1, filedName.length());
                        }
                        Method getMethod = source.getClass().getMethod(getMethodName, new Class[]{});
                        if (getMethod != null)
                        {
                            Object getValue = getMethod.invoke(source, new Object[]{}); //get值
                            if (getValue != null && getMethod.getReturnType() != null)
                            {
                                Method setMethod = target.getClass().getMethod(setMethodName, new Class[]{getMethod.getReturnType()});
                                if (setMethod != null)
                                {
                                    setMethod.invoke(target, new Object[]{getValue});
                                }
                            }
                        }
                    }
                }
                catch (Exception e)
                {
//                    e.printStackTrace();
                }
            }
        }
        catch (Exception e)
        {
//            e.printStackTrace();
        }
    }

    /**
     * Bean属性拷贝，适合用于拷贝至空的对象.
     *
     * @param source 源对象
     * @param target 目标对象
     */
    public static void copyBeanProperties(Object source, Object target)
    {
        if (source != null)
        {
            org.springframework.beans.BeanUtils.copyProperties(source, target);
        }
    }

    /**
     * Bean属性拷贝，适合用于拷贝至空的对象.
     *
     * @param source 源对象
     * @param clazz  目标对象
     * @return Object
     */
    public static Object copyBeanPropertiesForClass(Object source, Class<?> clazz) throws Exception
    {
        if (source != null)
        {
            Object target = clazz.newInstance();
            copyBeanProperties(source, target);
            return target;
        }
        return null;
    }

}
