package com.infoepoch.pms.dispatchassistant.common.easyExcel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.infoepoch.pms.dispatchassistant.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NoModalDataListener extends AnalysisEventListener<Map<Integer, String>> {

    private final static Logger logger = LoggerFactory.getLogger(NoModalDataListener.class);

    private List<Map<Integer, String>> headList;
    private List<Map<Integer, String>> dataList;

    public NoModalDataListener() {
        this.headList = new ArrayList<>();
        this.dataList = new ArrayList<>();
    }

    @Override
    public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
        logger.info("解析到一条数据:{}", JsonUtils.objectToJson(headMap));
        headList.add(headMap);
    }

    @Override
    public void invoke(Map<Integer, String> integerStringMap, AnalysisContext analysisContext) {
        logger.info("解析到一条数据:{}", JsonUtils.objectToJson(integerStringMap));
        dataList.add(integerStringMap);
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
        logger.info("所有数据解析完成");
    }

    public List<Map<Integer, String>> getHeadList() {
        return headList;
    }

    public List<Map<Integer, String>> getDataList() {
        return dataList;
    }
}
