package com.infoepoch.pms.dispatchassistant.common.easyExcel;

import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.style.column.AbstractColumnWidthStyleStrategy;
import org.apache.poi.ss.usermodel.Cell;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomHeadWriteHandler extends AbstractColumnWidthStyleStrategy {

    private Map<Integer, Map<Integer, Integer>> CACHE = new HashMap<>();

    public CustomHeadWriteHandler() {
    }

    public CustomHeadWriteHandler(Map<Integer, Map<Integer, Integer>> CACHE) {
        this.CACHE = CACHE;
    }

    @Override
    protected void setColumnWidth(WriteSheetHolder writeSheetHolder, List<CellData> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        if (CACHE.size() > 0) {
            Map<Integer, Integer> columnWidthMap = CACHE.get(writeSheetHolder.getSheetNo());
            if (columnWidthMap == null) {
                columnWidthMap = new HashMap<>();
                CACHE.put(writeSheetHolder.getSheetNo(), columnWidthMap);
            }
            Integer columnWidth = columnWidthMap.get(cell.getColumnIndex());
            if(columnWidth == null || columnWidth == 0) {
                columnWidth = this.dataLength(cellDataList, cell, isHead);
            }
            if (columnWidth >= 0) {
                if (columnWidth > 255) {
                    columnWidth = 255;
                }
                Integer maxColumnWidth = columnWidthMap.get(cell.getColumnIndex());
                if (maxColumnWidth == null || columnWidth > maxColumnWidth) {
                    columnWidthMap.put(cell.getColumnIndex(), columnWidth);
                }
                writeSheetHolder.getSheet().setColumnWidth(cell.getColumnIndex(), columnWidth * 256);
            }
        }
    }

    private Integer dataLength(List<CellData> cellDataList, Cell cell, Boolean isHead) {
        if (isHead) {
            return cell.getStringCellValue().getBytes().length;
        } else {
            CellData cellData = cellDataList.get(0);
            CellDataTypeEnum type = cellData.getType();
            if (type == null) {
                return -1;
            } else {
                switch (type) {
                    case STRING:
                        return cellData.getStringValue().getBytes().length;
                    case BOOLEAN:
                        return cellData.getBooleanValue().toString().getBytes().length;
                    case NUMBER:
                        return cellData.getNumberValue().toString().getBytes().length;
                    default:
                        return -1;
                }
            }
        }
    }

}
