/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.failover.utils;

import com.oceanbase.jdbc.HostAddress;
import com.oceanbase.jdbc.UrlParser;
import com.oceanbase.jdbc.internal.failover.BlackList.BlackListConfig;
import com.oceanbase.jdbc.internal.failover.BlackList.append.RetryDuration;
import com.oceanbase.jdbc.internal.failover.impl.LoadBalanceAddressList;
import com.oceanbase.jdbc.internal.failover.impl.LoadBalanceHostAddress;
import com.oceanbase.jdbc.internal.failover.impl.LoadBalanceInfo;
import com.oceanbase.jdbc.internal.failover.utils.CONFIGTYPE;
import com.oceanbase.jdbc.internal.failover.utils.STATE;
import com.oceanbase.jdbc.internal.failover.utils.ZONE;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.internal.util.constant.HaMode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ConfigParser {
    static ConcurrentHashMap<String, LoadBalanceInfo> loadBalanceInfos = new ConcurrentHashMap();

    public static ConcurrentHashMap<String, LoadBalanceInfo> getLoadBalanceInfosFromReader(Reader reader) throws IOException {
        LoadBalanceInfo loadBalanceInfo = null;
        BlackListConfig blackListConfig = null;
        LoadBalanceAddressList loadBalanceAddressList = null;
        HostAddress loadBalanceHostAddress = null;
        StringBuilder word = new StringBuilder();
        char[] buffer = new char[1024];
        int readNum = 0;
        STATE state = STATE.NONE;
        int bracketsCount = 0;
        CONFIGTYPE curConfigType = CONFIGTYPE.NONE;
        String str = null;
        ZONE curZone = ZONE.NONE;
        String currentNetServiceName = "";
        while ((readNum = reader.read(buffer)) != -1) {
            block29: for (int i = 0; i < readNum; ++i) {
                char cur = buffer[i];
                switch (cur) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block29;
                    }
                    case '(': {
                        state = STATE.LEAFBRACKETS;
                        ++bracketsCount;
                        continue block29;
                    }
                    case ')': {
                        if (--bracketsCount == 0) {
                            loadBalanceInfos.put(currentNetServiceName, loadBalanceInfo);
                            state = STATE.NONE;
                            curConfigType = CONFIGTYPE.NONE;
                            word = new StringBuilder();
                        }
                        if (bracketsCount > 0 && curConfigType != CONFIGTYPE.NONE) {
                            String value = word.toString();
                            switch (curConfigType) {
                                case SERVICE_NAME: {
                                    loadBalanceInfo.setServiceName(value);
                                    break;
                                }
                                case RETRYALLDOWNS: {
                                    loadBalanceInfo.setRetryAllDowns(Integer.parseInt(value));
                                    break;
                                }
                                case GROUPSTRATEGY: {
                                    loadBalanceInfo.getGroupBalanceStrategyConfigs().put("NAME", value.toUpperCase());
                                    break;
                                }
                                case LOADBALANCESTRATEGY: 
                                case LOADBALANCESTRATEGYALIAS: {
                                    if (curZone == ZONE.INDESCRIPTION) {
                                        loadBalanceInfo.getBalanceStrategyConfigs().put("NAME", value.toUpperCase());
                                    } else {
                                        loadBalanceInfo.getGroups().get(loadBalanceInfo.getGroups().size() - 1).getBalanceStrategyConfigs().put("NAME", value.toUpperCase());
                                    }
                                }
                                case LOADBALANCEALIAS: 
                                case LOADBALANCE: {
                                    if (value.equalsIgnoreCase("ON")) {
                                        loadBalanceInfo.setHaMode(HaMode.LOADBALANCE);
                                        break;
                                    }
                                    loadBalanceInfo.setHaMode(HaMode.NONE);
                                    break;
                                }
                                case NAME: {
                                    if (curZone == ZONE.INREMOVESTRATGY) {
                                        blackListConfig.getRemoveStrategyConfigs().put("NAME", "TIMEOUT");
                                        break;
                                    }
                                    blackListConfig.getAppendStrategyConfigs().put("NAME", value.toUpperCase());
                                    break;
                                }
                                case TIMEOUT: {
                                    blackListConfig.getRemoveStrategyConfigs().put("TIMEOUT", value.toUpperCase());
                                    break;
                                }
                                case RETRYTIMES: {
                                    blackListConfig.getAppendStrategyConfigs().put("RETRYTIMES", value.toUpperCase());
                                    break;
                                }
                                case DURATION: {
                                    blackListConfig.getAppendStrategyConfigs().put("DURATION", value.toUpperCase());
                                    RetryDuration.updateMaxDuration(Long.parseLong(value));
                                    break;
                                }
                                case PORT: {
                                    loadBalanceHostAddress.setPort(Integer.parseInt(value));
                                    break;
                                }
                                case HOST: {
                                    loadBalanceHostAddress.setHost(value);
                                    break;
                                }
                                case WEIGHT: {
                                    ((LoadBalanceHostAddress)loadBalanceHostAddress).setWeight(Integer.parseInt(value));
                                    break;
                                }
                            }
                            state = STATE.NONE;
                            curConfigType = CONFIGTYPE.NONE;
                            word = new StringBuilder();
                            continue block29;
                        }
                        if (state != STATE.INBRACKETS) continue block29;
                        str = word.toString();
                        if (bracketsCount == 0) {
                            state = STATE.NONE;
                            continue block29;
                        }
                        state = STATE.RIGHTBRACKETS;
                        word = new StringBuilder();
                        continue block29;
                    }
                    case '=': {
                        str = word.toString();
                        boolean inKeys = false;
                        CONFIGTYPE[] configEnums = CONFIGTYPE.values();
                        CONFIGTYPE tmp = CONFIGTYPE.NONE;
                        for (CONFIGTYPE v : configEnums) {
                            if (!str.equalsIgnoreCase(v.name)) continue;
                            tmp = v;
                            inKeys = true;
                        }
                        if (!inKeys) {
                            currentNetServiceName = str;
                        }
                        if (tmp != CONFIGTYPE.NONE) {
                            curConfigType = tmp;
                        }
                        switch (curConfigType) {
                            case DESCRIPTION: {
                                curZone = ZONE.INDESCRIPTION;
                                loadBalanceInfo = new LoadBalanceInfo();
                                break;
                            }
                            case BLACKLISTSTRATECONFIG: {
                                curZone = ZONE.INBLACKLIST;
                                blackListConfig = new BlackListConfig();
                                loadBalanceInfo.setBlackListConfig(blackListConfig);
                                break;
                            }
                            case REMOVESTRATEGY: {
                                curZone = ZONE.INREMOVESTRATGY;
                                break;
                            }
                            case APPENDSTRATEGY: {
                                curZone = ZONE.INAPPENDSTRATGY;
                                break;
                            }
                            case ADDRESSLIST: {
                                curZone = ZONE.INADDRESSLIST;
                                loadBalanceAddressList = new LoadBalanceAddressList();
                                loadBalanceInfo.getGroups().add(loadBalanceAddressList);
                                break;
                            }
                            case ADDRESS: {
                                curZone = ZONE.INADDRESS;
                                loadBalanceHostAddress = new LoadBalanceHostAddress(null, 0);
                                loadBalanceAddressList.getAddressList().add((LoadBalanceHostAddress)loadBalanceHostAddress);
                            }
                        }
                        word = new StringBuilder();
                        continue block29;
                    }
                    default: {
                        if (state == STATE.LEAFBRACKETS) {
                            state = STATE.INBRACKETS;
                        }
                        word.append(cur);
                    }
                }
            }
        }
        return loadBalanceInfos;
    }

    public static TnsFileInfo getTnsFilePath() throws SQLException {
        TnsFileInfo tnsFileInfo = new TnsFileInfo();
        String tnsPath = System.getProperty("oceanbase.tns_admin");
        String tnsEnv = System.getenv("OCEANBASE_TNS_ADMIN");
        if (tnsEnv == null && tnsPath == null) {
            throw new SQLException("Unknown TNS_ADMIN specified ");
        }
        if (tnsPath == null) {
            tnsPath = tnsEnv;
        }
        String configFileName = "tnsnames.ob";
        String tnsConfigName = System.getProperty("oceanbase.tns_admin_name");
        String tnsConfigNameEnv = System.getenv("OCEANBASE_TNS_ADMIN_NAME");
        if (tnsConfigName != null) {
            configFileName = tnsConfigName;
        }
        if (tnsConfigNameEnv != null) {
            configFileName = tnsConfigNameEnv;
        }
        tnsFileInfo.path = tnsPath;
        tnsFileInfo.name = configFileName;
        return tnsFileInfo;
    }

    public static LoadBalanceInfo getGloabalLoadBalanceInfo(UrlParser urlParser) throws SQLException, IOException {
        if (urlParser.getTnsServiceName() != null) {
            if (Utils.tnsDaemon == null) {
                TnsFileInfo tnsFileInfo = ConfigParser.getTnsFilePath();
                String filePath = tnsFileInfo.path + "/" + tnsFileInfo.name;
                File file = new File(filePath);
                InputStreamReader reader = new InputStreamReader(new FileInputStream(file));
                ConfigParser.getLoadBalanceInfosFromReader(reader);
                return loadBalanceInfos.get(urlParser.getTnsServiceName());
            }
            if (Utils.tnsDaemon.getState() == Thread.State.TERMINATED) {
                throw new SQLException("Config file daemon thread  is TERMINATED");
            }
            LoadBalanceInfo tnsPropertis = loadBalanceInfos.get(urlParser.getTnsServiceName());
            if (tnsPropertis == null) {
                throw new SQLException("Unknown host specified ");
            }
            return tnsPropertis;
        }
        if (urlParser.getExtendDescription() != null) {
            loadBalanceInfos = ConfigParser.getLoadBalanceInfosFromReader(new StringReader(urlParser.getExtendDescription()));
            String netServiceName = ConfigParser.getNetServiceName(urlParser.getExtendDescription());
            return loadBalanceInfos.get(netServiceName);
        }
        LoadBalanceInfo ret = new LoadBalanceInfo();
        String strategy = urlParser.getOptions().loadBalanceStrategy.toUpperCase();
        ret.getBalanceStrategyConfigs().put("NAME", strategy);
        String serverAffinityOrder = urlParser.getOptions().serverAffinityOrder;
        if (serverAffinityOrder == null || serverAffinityOrder.equals("")) {
            List<HostAddress> addressList = urlParser.getHostAddresses();
            LoadBalanceAddressList loadBalanceAddressList = new LoadBalanceAddressList();
            for (HostAddress address : addressList) {
                LoadBalanceHostAddress loadBalanceHostAddress = new LoadBalanceHostAddress(address.host, address.port);
                loadBalanceAddressList.addressList.add(loadBalanceHostAddress);
            }
            ret.getGroups().add(loadBalanceAddressList);
        } else {
            serverAffinityOrder = serverAffinityOrder.trim();
            String[] urls = serverAffinityOrder.split(",");
            ConcurrentHashMap weights = new ConcurrentHashMap();
            LoadBalanceAddressList loadBalanceAddressList = new LoadBalanceAddressList();
            for (String str : urls) {
                LoadBalanceHostAddress loadBalanceHostAddress = new LoadBalanceHostAddress("0.0.0.0", 0);
                String[] vals = str.split(":");
                loadBalanceHostAddress.setHost(vals[0]);
                loadBalanceHostAddress.setPort(Integer.parseInt(vals[1]));
                if (vals.length == 3) {
                    loadBalanceHostAddress.setWeight(Integer.parseInt(vals[2]));
                } else {
                    loadBalanceHostAddress.setWeight(1);
                }
                loadBalanceAddressList.addressList.add(loadBalanceHostAddress);
            }
            ret.getGroups().add(loadBalanceAddressList);
        }
        return ret;
    }

    public static String getNetServiceName(String extendDescription) throws SQLException {
        int endIndex;
        int startIndex;
        String tmp = extendDescription.trim();
        String value = tmp.substring((startIndex = tmp.indexOf("(")) + 1, endIndex = tmp.indexOf("="));
        if (value.trim().equalsIgnoreCase("DESCRIPTION")) {
            throw new SQLException("Url config format error !");
        }
        return value.trim();
    }

    public static class TnsFileInfo {
        public String name;
        public String path;
    }
}

