/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.ObStruct;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.OceanBaseXid;
import com.oceanbase.jdbc.extend.datatype.ComplexDataType;
import com.oceanbase.jdbc.extend.datatype.StructImpl;
import com.oceanbase.jdbc.internal.util.Utils;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class OceanBaseXaResource
implements XAResource {
    private static final int MAX_COMMAND_LENGTH = 300;
    private final OceanBaseConnection connection;
    private boolean isChangedCommit;

    public OceanBaseXaResource(OceanBaseConnection connection) {
        this.connection = connection;
    }

    protected static String xidToString(Xid xid) {
        return "0x" + Utils.byteArrayToHexString(xid.getGlobalTransactionId()) + ",0x" + Utils.byteArrayToHexString(xid.getBranchQualifier()) + ",0x" + Utils.intToHexString(xid.getFormatId());
    }

    private static String flagsToString(int flags) {
        switch (flags) {
            case 0x200000: {
                return "JOIN";
            }
            case 0x40000000: {
                return "ONE PHASE";
            }
            case 0x8000000: {
                return "RESUME";
            }
            case 0x2000000: {
                return "SUSPEND";
            }
        }
        return "";
    }

    private XAException mapXaException(SQLException sqle) {
        int xaErrorCode;
        switch (sqle.getErrorCode()) {
            case 1397: {
                xaErrorCode = -4;
                break;
            }
            case 1398: {
                xaErrorCode = -5;
                break;
            }
            case 1399: {
                xaErrorCode = -7;
                break;
            }
            case 1400: {
                xaErrorCode = -9;
                break;
            }
            case 1401: {
                xaErrorCode = -3;
                break;
            }
            case 1402: {
                xaErrorCode = 100;
                break;
            }
            default: {
                xaErrorCode = 0;
            }
        }
        XAException xaException = xaErrorCode != 0 ? new XAException(xaErrorCode) : new XAException(sqle.getMessage());
        xaException.initCause(sqle);
        return xaException;
    }

    private XAException mapXaException2(SQLException sqle) {
        XAException xaException = new XAException(-7);
        xaException.initCause(sqle);
        return xaException;
    }

    private void execute(String command) throws XAException {
        try {
            this.connection.createStatement().execute(command);
        }
        catch (SQLException sqle) {
            throw this.mapXaException(sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.connection.getProtocol().isOracleMode()) {
            StringBuilder commandBuf = new StringBuilder(300);
            commandBuf.append("select DBMS_XA.XA_COMMIT(?, ?) from dual");
            ObStruct xidObj = this.genOracleXid(xid);
            try {
                this.dispatchOracleCommand(commandBuf.toString(), xidObj, onePhase);
            }
            finally {
                this.connection.setInGlobalTx(false);
            }
        } else {
            String command = "XA COMMIT " + OceanBaseXaResource.xidToString(xid);
            if (onePhase) {
                command = command + " ONE PHASE";
            }
            this.execute(command);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (this.connection.getProtocol().isOracleMode()) {
            StringBuilder commandBuf = new StringBuilder(300);
            commandBuf.append("select DBMS_XA.XA_END(?, ?) from dual");
            ObStruct xidObj = this.genOracleXid(xid);
            this.dispatchOracleCommand(commandBuf.toString(), xidObj, flags);
            try {
                OceanBaseConnection mySQLConnection = this.connection;
                if (!this.isChangedCommit) return;
                mySQLConnection.setAutoCommit(true);
                this.isChangedCommit = false;
                return;
            }
            catch (SQLException e) {
                throw this.mapXaException2(e);
            }
        } else {
            if (flags != 0x4000000 && flags != 0x2000000 && flags != 0x20000000) {
                throw new XAException(-5);
            }
            this.execute("XA END " + OceanBaseXaResource.xidToString(xid) + " " + OceanBaseXaResource.flagsToString(flags));
        }
    }

    @Override
    public void forget(Xid xid) {
    }

    @Override
    public int getTransactionTimeout() {
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource xaResource) {
        return false;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (this.connection.getProtocol().isOracleMode()) {
            StringBuilder commandBuf = new StringBuilder(300);
            commandBuf.append("select DBMS_XA.XA_PREPARE(?) from dual");
            ObStruct xidObj = this.genOracleXid(xid);
            int xaRet = this.dispatchOracleCommand(commandBuf.toString(), xidObj);
            return xaRet;
        }
        this.execute("XA PREPARE " + OceanBaseXaResource.xidToString(xid));
        return 0;
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        if ((flags & 0x1000000) == 0 && (flags & 0x800000) == 0 && flags != 0) {
            throw new XAException(-5);
        }
        if ((flags & 0x1000000) == 0) {
            return new OceanBaseXid[0];
        }
        if (this.connection.getProtocol().isOracleMode()) {
            ArrayList<OceanBaseXid> recoveredXidList = new ArrayList<OceanBaseXid>();
            PreparedStatement psStmt = null;
            ResultSet rs = null;
            ResultSet arrayRes = null;
            String command = "declare   x DBMS_XA_XID_ARRAY := DBMS_XA_XID_ARRAY(); BEGIN   x := DBMS_XA.XA_RECOVER();   ? := x;END;";
            try {
                OceanBaseConnection mySQLConnection = this.connection;
                psStmt = mySQLConnection.prepareStatement(command);
                psStmt.setNull(1, 0);
                rs = psStmt.executeQuery();
                while (rs.next()) {
                    Array array = rs.getArray(1);
                    arrayRes = array.getResultSet();
                    while (arrayRes.next()) {
                        Struct struct = (Struct)arrayRes.getObject(2);
                        Object[] objArr = struct.getAttributes();
                        recoveredXidList.add(new OceanBaseXid(((String)objArr[1]).getBytes(), ((String)objArr[2]).getBytes(), ((BigDecimal)objArr[0]).intValue()));
                    }
                }
            }
            catch (SQLException sqlEx) {
                throw new XAException(-7);
            }
            finally {
                try {
                    if (arrayRes != null) {
                        arrayRes.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (psStmt != null) {
                        psStmt.close();
                    }
                }
                catch (SQLException sqlEx) {
                    throw this.mapXaException2(sqlEx);
                }
            }
            int numXids = recoveredXidList.size();
            Xid[] asXids = new Xid[numXids];
            Object[] asObjects = recoveredXidList.toArray();
            for (int i = 0; i < numXids; ++i) {
                asXids[i] = (Xid)asObjects[i];
            }
            return asXids;
        }
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("XA RECOVER");
            ArrayList<OceanBaseXid> xidList = new ArrayList<OceanBaseXid>();
            while (rs.next()) {
                int formatId = rs.getInt(1);
                int len1 = rs.getInt(2);
                int len2 = rs.getInt(3);
                byte[] arr = rs.getBytes(4);
                byte[] globalTransactionId = new byte[len1];
                byte[] branchQualifier = new byte[len2];
                System.arraycopy(arr, 0, globalTransactionId, 0, len1);
                System.arraycopy(arr, len1, branchQualifier, 0, len2);
                xidList.add(new OceanBaseXid(formatId, globalTransactionId, branchQualifier));
            }
            Xid[] xids = new Xid[xidList.size()];
            xidList.toArray(xids);
            return xids;
        }
        catch (SQLException sqle) {
            throw this.mapXaException(sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        if (this.connection.getProtocol().isOracleMode()) {
            StringBuilder commandBuf = new StringBuilder(300);
            commandBuf.append("select DBMS_XA.XA_ROLLBACK(?) from dual");
            ObStruct xidObj = this.genOracleXid(xid);
            try {
                this.dispatchOracleCommand(commandBuf.toString(), xidObj);
            }
            finally {
                this.connection.setInGlobalTx(false);
            }
        } else {
            this.execute("XA ROLLBACK " + OceanBaseXaResource.xidToString(xid));
        }
    }

    @Override
    public boolean setTransactionTimeout(int timeout) {
        return false;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (flags != 0x200000 && flags != 0x8000000 && flags != 0) {
            throw new XAException(-5);
        }
        if (this.connection.getProtocol().isOracleMode()) {
            StringBuilder commandBuf = new StringBuilder(300);
            commandBuf.append("select DBMS_XA.XA_START(?, ?) from dual");
            ObStruct xidObj = this.genOracleXid(xid);
            try {
                OceanBaseConnection mySQLConnection = this.connection;
                boolean isAutoCommit = mySQLConnection.getAutoCommit();
                if (isAutoCommit) {
                    mySQLConnection.setAutoCommit(false);
                    this.isChangedCommit = true;
                } else {
                    this.isChangedCommit = false;
                }
            }
            catch (SQLException e) {
                throw this.mapXaException2(e);
            }
            try {
                this.dispatchOracleCommand(commandBuf.toString(), xidObj, flags);
            }
            catch (XAException e) {
                try {
                    OceanBaseConnection mySQLConnection = this.connection;
                    if (this.isChangedCommit) {
                        mySQLConnection.setAutoCommit(true);
                        this.isChangedCommit = false;
                    }
                }
                catch (SQLException se) {
                    throw this.mapXaException2(se);
                }
                throw e;
            }
        }
        this.execute("XA START " + OceanBaseXaResource.xidToString(xid) + " " + OceanBaseXaResource.flagsToString(flags == 0x200000 && this.connection.getPinGlobalTxToPhysicalConnection() ? 0x8000000 : flags));
    }

    private ObStruct genOracleXid(Xid xid) throws XAException {
        try {
            OceanBaseConnection mySQLConnection = this.connection;
            Object[] xidObj = new Object[3];
            int i = 0;
            xidObj[i++] = xid.getFormatId();
            xidObj[i++] = xid.getGlobalTransactionId();
            xidObj[i++] = xid.getBranchQualifier();
            ComplexDataType complexType = null;
            if (this.connection.getProtocol().getOptions().useLocalXID) {
                String childTypeName = "DBMS_XA_XID";
                String ownerName = "SYS";
                int type = 3;
                complexType = new ComplexDataType(childTypeName, ownerName, type);
                complexType.setValid(true);
                complexType.setAttrCount(3);
                complexType.setAttrType(0, new ComplexDataType("NUMBER", "", 0));
                complexType.incInitAttrCount();
                complexType.setAttrType(1, new ComplexDataType("RAW", "", 6));
                complexType.incInitAttrCount();
                complexType.setAttrType(2, new ComplexDataType("RAW", "", 6));
                complexType.incInitAttrCount();
                StructImpl struct = new StructImpl(complexType);
                struct.setAttrData(xidObj);
                return struct;
            }
            return (ObStruct)mySQLConnection.createStruct("DBMS_XA_XID", xidObj);
        }
        catch (SQLException sqlEx) {
            throw this.mapXaException2(sqlEx);
        }
    }

    private int dispatchOracleCommand(String command, ObStruct xid) throws XAException {
        return this.dispatchOracleCommand(command, xid, null);
    }

    /*
     * Loose catch block
     */
    private int dispatchOracleCommand(String command, ObStruct xid, Object param) throws XAException {
        PreparedStatement psStmt = null;
        try {
            block17: {
                int n;
                block18: {
                    OceanBaseConnection mySQLConnection = this.connection;
                    psStmt = mySQLConnection.prepareStatement(command);
                    psStmt.setObject(1, xid);
                    if (param != null) {
                        psStmt.setObject(2, param);
                    }
                    ResultSet rs = null;
                    rs = psStmt.executeQuery();
                    if (!rs.next()) break block17;
                    int xaRet = rs.getInt(1);
                    if (xaRet < 0) {
                        XAException xaException = new XAException(xaRet);
                        throw xaException;
                    }
                    n = xaRet;
                    if (rs == null) break block18;
                    {
                        catch (Throwable throwable) {
                            if (rs != null) {
                                rs.close();
                            }
                            throw throwable;
                        }
                    }
                    rs.close();
                }
                return n;
            }
            try {
                throw new XAException(-7);
            }
            catch (SQLException sqlEx) {
                sqlEx.printStackTrace();
                throw this.mapXaException2(sqlEx);
            }
        }
        finally {
            if (psStmt != null) {
                try {
                    psStmt.close();
                }
                catch (SQLException sqlEx) {
                    throw this.mapXaException2(sqlEx);
                }
            }
        }
    }
}

