//Ajax全局配置
require(['layer'], function (layer) {
    /**
     * XMLHttpRequest 下载文件
     * @params {String} obj.type -请求类型
     * @params {String} obj.url -请求地址
     * @params {FromData} obj.data -参数
     * @callback {Function} obj.success -请求成功回调
     * */
    window.xhrDownloadFile = function (obj) {
        top.layer.load(0);
        var xhr = new XMLHttpRequest();
        xhr.open(obj.type, obj.url, true);
        xhr.send(obj.data);
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4 && xhr.status == 200) {
                // 请求成功
                if (xhr.getResponseHeader("Content-type") != 'application/json;charset=UTF-8') {
                    // 返回文件流数据
                    obj.success()
                } else {
                    // 返回json
                    var result = JSON.parse(xhr.responseText);
                    if (!result.success) {
                        if (result.code == 1) {
                            if (self != top) {
                                top.location.href = '/epms/api/sso/login-oa';
                            } else {
                                location.href = '/epms/api/sso/login-oa';
                            }
                        } else if (result.code == 5) {
                            if (self != top) {
                                top.location.href = '../pages/common/cwp-login.html';
                            } else {
                                location.href = '../pages/common/cwp-login.html';
                            }
                        } else {
                            if (result.code != 165003) {
                                layer.msg(result.message);
                            }
                        }
                    } else {
                        layer.msg(result.message)
                    }
                }
            }
        }
        xhr.onloadend = function () {
            // 请求结束
            top.layer.closeAll('loading');
        }
    }
});

