//流程引擎选择单个人员组件，使用树组件
define(['jquery', 'vue', 'peac-history'], function ($, Vue) {
    return Vue.component('peac-show-history', {
        props: {
            deploySid: {default: ''},
            domainId: {default: ''},
        },
        data: function () {
            return {
                histories: [],
            }
        },
        template: '<peac-history v-if="histories.length>0" :histories="histories"></peac-history>',
        created: function () {
        },
        mounted: function () {
        },
        watch: {
            domainId: function (val) {
                this.showHistory()
            }
        },
        methods: {
            showHistory: function () {
                var that = this;
                if (this.deploySid != '' && this.domainId != '') {
                    $.ajax({
                        type: 'GET',
                        url: '/api/process-engine/runtime/history',
                        data: {deploySid: that.deploySid, domainId: that.domainId},
                        success: function (data) {
                            that.histories = data.data;
                        }
                    });
                }
            },
        }
    });
});
