//流程引擎历史记录组件
define(['jquery', 'vue'], function ($, Vue) {
    return Vue.component('peac-history-v2', {
        props: {
            deploySid: '',                                       //部署流程标识符
            domainId: '',                                        //领域对象Id
        },
        data: function () {
            return {
                showSystem: false,
                histories: []
            }
        },
        template: '\
          <div v-if="histories.length>0" class="block_container">\
            <div class="title">审批流程\
             <div style="float: right;">\
              <label><input type="checkbox" @click="showSystem = !showSystem" class="processv2-check" /> 显示系统活动</label>\
             </div>\
            </div>\
            <div class="content">\
            <div style="color: #333333; font-weight: normal;">\
                    <table class="table table_list table_striped text_center">\
                        <thead>\
                            <tr>\
                                <th>序号</th>\
                                <th>流程步骤</th>\
                                <th>处理人</th>\
                                <th>送达时间</th>\
                                <th>完成时间</th>\
                                <th>状态</th>\
                                <th>处理意见/结果</th>\
                            </tr>\
                        </thead>\
                        <tbody>\
                            <template v-for="(history, index) in filterHistories">\
                            <tr v-if="history.activityType != \'SubprocessBegin\' && history.activityType != \'SubprocessEnd\'">\
                                <td>{{index + 1}}</td>\
                                <td>{{history.activityName}}</td>\
                                <td>{{history.actorName}}</td>\
                                <td>{{history.beginTime}}</td>\
                                <td>{{history.finishTime}}</td>\
                                <td style="white-space: nowrap;">{{getHistoryState(history)}}</td>\
                                <td class="text-left">{{history.comment}}</td>\
                            </tr>\
                            <tr v-if="history.activityType == \'SubprocessBegin\'" style="background-image: linear-gradient(to bottom, #DDDDDD, #FFFFFF);">\
                                <td>{{index + 1}}</td>\
                                <td colspan="6">{{history.activityName}} （{{history.finished?"已结束":"未结束"}}）</td>\
                            </tr>\
                            <tr v-if="history.activityType == \'SubprocessEnd\'" style="background-image: linear-gradient(to bottom, #FFFFFF, #DDDDDD);">\
                                <td colspan="7"></td>\
                            </tr>\
                            </template>\
                        </tbody>\
                    </table></div></div></div>',
        created: function () {
            //子组件中需要增加v-if判断以结束递归
        },
        mounted: function () {
            this.loadHistory();
        },
        watch: {
            deploySid: function (newValue, oldValue) {
                this.loadHistory();
            },
            domainId: function (newValue, oldValue) {
                this.loadHistory();
            }
        },
        computed: {
            filterHistories: function () {
                if (this.showSystem) {
                    return this.histories;
                } else {
                    return $.grep(this.histories, function (item, index) {
                        return item.activityType == 'Task' || (item.batchId == "" && item.activityType == "End");
                    });
                }
            }
        },
        methods: {
            getHistoryState: function (history) {
                if (!history.finished)
                    return '待处理';
                if (history.actionType == 'Return')
                    return '已退回';
                if (history.actionType == 'Deliver')
                    return '已转交';
                return '已处理';
            },
            //流程历史
            loadHistory: function () {
                var that = this;
                if (that.deploySid && that.domainId)
                    $.ajax({
                        type: 'GET',
                        url: getContextPath() + '/process-engine/api/runtime/history',
                        data: {deploySid: that.deploySid, domainId: that.domainId},
                        success: function (data) {
                            that.histories = data.data;
                        }
                    });
            }
        }
    });
});
