//流程引擎选择单个人员组件，使用树组件

define(['jquery', 'vue', '../../libs/jquery.ztree/fuzzysearch.js', 'jquery-ztree']
    , function ($, Vue, fuzzySearch) {
    return Vue.component('peac-base-user', {
        props: {
            restUrl: {default: ''},
            organizationId: {default: ''},      //当前用户所属组织Id
            userId: {default: ''},              //当前用户Id
            permission: {default: ''}

        },
        data: function () {
            return {
                selectedId: '',
                selectedName: '',
                treeId: 'tree' + Math.floor(100000000 + Math.random() * 900000000),     //生成随机id
                searchId: 'search' + Math.floor(100000000 + Math.random() * 900000000)  //生成随机id
            }
        },
        template: '<div>\
                    <div class="peac_column peac_column_tree" style="overflow: hidden;">\
                        <div class="peac_column_title">\
                        <!--<a href="javascript:void(null);" @click="expand">展开</a>-->\
                        <!--<a href="javascript:void(null);" @click="collapse">收起</a>-->\
                        <input type="text" :id="searchId" class="form_control" placeholder="请输入搜索内容" />\
                        </div>\
                        <div class="peac_tree_container">\
                            <ul :id="treeId" class="ztree"></ul>\
                        </div>\
                    </div>\
                    <div class="peac_column peac_column_selected">\
                        <div class="peac_column_title">已选择人员</div>\
                        <div class="peac_selected_container">\
                            <div class="peac_selected_item" v-if="selectedId != \'\'">\
                                <div class="peac_selected_name">{{selectedName}}</div>\
                                <div class="peac_selected_remove" @click="clear">╳</div>\
                            </div>\
                        </div>\
                    </div>\
                </div>',
        created: function () {
        },
        mounted: function () {
            this.bindTree();
        },
        watch: {
            url: function (newValue, oldValue) {
                this.bindTree();
            },
            organizationId: function (newValue, oldValue) {
                this.bindTree();
            },
            userId: function (newValue, oldValue) {
                this.bindTree();
            },
            permission: function(newValue, oldValue){
                this.bindTree();
            }
        },
        computed: {},
        methods: {
            bindTree: function () {
                if (this.restUrl == '' || this.organizationId == ''){
                    $.fn.zTree.destroy(this.treeId);
                    return;
                }

                var setting = {
                    check: {
                        enable: true,
                        chkStyle: 'radio',
                        radioType: 'all'
                    },
                    view: {showIcon: false},
                    callback: {
                        onClick: function (event, treeId, treeNode) {
                            var zTree = $.fn.zTree.getZTreeObj(treeId);
                            if (treeNode.isParent) {
                                if (treeNode.open) {
                                    zTree.expandNode(treeNode, false);
                                } else {
                                    zTree.expandNode(treeNode, true);
                                }
                            } else {
                                zTree.checkNode(treeNode, !treeNode.checked, true, true);
                            }
                        },
                        onCheck: function (event, treeId, treeNode) {
                            //console.log(treeNode);
                            //console.log(treeId + ', ' + treeNode.tId + ', ' + treeNode.id + ', ' + treeNode.name + ',' + treeNode.checked);
                            if (treeNode.checked) {
                                that.selectedId = treeNode.id;
                                if (treeNode.oldname != undefined)
                                    that.selectedName = treeNode.oldname;
                                else
                                    that.selectedName = treeNode.name;
                            } else {
                                that.selectedId = '';
                                that.selectedName = '';
                            }
                        }
                    }
                };

                var that = this;
                $.ajax({
                    dataType: 'JSON',
                    type: 'GET',
                    url: that.restUrl,
                    data: {organizationId: that.organizationId, userId: that.userId, permission: that.permission},
                    success: function (data) {
                        var zNodes = data.data;
                        var zTreeObj = $.fn.zTree.init($('#' + that.treeId), setting, zNodes);    //绑定树
                        fuzzySearch.fuzzySearch(that.treeId, '#' + that.searchId, true, true);
                        //自动展开第一个根节点
                        if(zTreeObj.getNodes().length > 0)
                            zTreeObj.expandNode(zTreeObj.getNodes()[0], true);
                    }
                });
            },
            clear: function () {
                this.selectedId = '';
                this.selectedName = '';
                var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                var nodes = treeObj.getCheckedNodes(true);
                if (nodes.length > 0)
                    treeObj.checkNode(nodes[0], false);
            },
            expand: function () {
                var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                treeObj.expandAll(true);
            },
            collapse: function () {
                var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                treeObj.expandAll(false);
            },
            search: function () {
                var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                treeObj.fuzzySearch(false);
            },
            verifyValue: function () {
                if (this.selectedId == '' || this.selectedId == null) {
                    // alert('请选择处理人。');
                    layer.confirm('请选择处理人。',
                        {title:'提示',btn: ['确定'],closeBtn: 0 },
                        function(index){
                            layer.close(index);
                        });
                    return false;
                }
                return true;
            },
            getValue: function () {
                return this.selectedId + '::' + this.selectedName;
            }
        }
    });
});
