// 拍照上传预览
define(['jquery', 'vue', 'vant'], function ($, Vue, vant) {
    return Vue.component('upload-picture', {
        props: {
            value: {
                default: function () {
                    return [];
                }
            },
            maxCount: {
                default: undefined
            }
        },
        data: function () {
            return {
                fileList: []
            }
        },
        template: '<van-uploader\
                    capture="camera"\
                    multiple\
                    v-model="fileList"\
                    :max-count="maxCount"\
                    :after-read="afterRead"\
                    @delete="deleteFile"></van-uploader>',
        created: function () {

        },
        mounted: function () {

        },
        watch: {
            value: {
                handler(val) {
                    // compareArray
                    if (Array.isArray(val)) {
                        if (!this.compareArray(val, this.getFileIds())) {
                            this.fileList = val.map((item) => {
                                return {url: fileStoreServer + '/api/image/' + item, isImage: true, id: item}
                            })
                        }
                    } else {
                        this.fileList = []
                    }
                },
                immediate: true
            }
        },
        computed: {},
        methods: {
            // 文件上传完毕后会触发 after-read 回调函数
            afterRead(file) {
                const that = this
                const formData = new FormData()
                formData.append('file', file.file)
                $.ajax({
                    url: fileStoreServer + '/api/upload',
                    type: 'POST',
                    contentType: false,
                    processData: false, // 必须false才会避开jQuery对 formdata 的默认处理, XMLHttpRequest会对 formdata 进行正确的处理
                    data: formData,
                    success(res) {
                        const index = that.fileList.indexOf(file)
                        that.fileList[index].id = res.data.id
                        that.$emit('input', that.getFileIds());
                    },
                    error(error) {
                        that.fileList = that.fileList.filter(function (item) {
                            return item.file != file.file
                        })
                    }
                })
            },
            deleteFile(file) {
                this.$emit('input', this.getFileIds());
            },
            getFileIds() {
                let fileIds = []
                if (Array.isArray(this.fileList)) {
                    fileIds = this.fileList.map((item) => {
                        return item.id
                    })
                }
                return fileIds
            },

            // 比较数组是否相同
            compareArray(arr1, arr2) {
                if (arr1.length != arr2.length)
                    return false

                if (arr1.length == arr2.length) {
                    for (var i = 0; i < arr1.length; i++) {
                        var index = arr2.indexOf(arr1[i].toString())
                        if (index == -1) {
                            return false;
                        }
                    }
                }
                return true
            }
        }
    });
})
