package com.infoepoch.pms.dispatchassistant.infractructure.basic.store;

import com.infoepoch.pms.dispatchassistant.common.utils.OracleUtils;
import com.infoepoch.pms.dispatchassistant.domain.basic.store.IKeyValueStoreRepository;
import com.infoepoch.pms.dispatchassistant.domain.basic.store.KeyValueStore;
import com.infoepoch.pms.dispatchassistant.domain.basic.store.KeyValueStoreCriteria;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 键值对仓库数据库操作实现类
 */
@Repository
public class KeyValueStoreRepository implements IKeyValueStoreRepository {

    @Autowired
    private JdbcTemplate jdbcTemplate;

//    public KeyValueStoreRepository(JdbcTemplate jdbcTemplate) {
//        this.jdbcTemplate = jdbcTemplate;
//    }

    @Override
    public void insert(KeyValueStore keyValueStore) {
        String sql = "INSERT INTO UTL_KEY_VALUE_STORE (KVS_KEY,KVS_VALUE) VALUES(?,?)";
        jdbcTemplate.update(sql, keyValueStore.getKey(), keyValueStore.getValue());
    }

    @Override
    public void update(KeyValueStore keyValueStore) {
        String sql = "UPDATE UTL_KEY_VALUE_STORE SET KVS_VALUE = ? WHERE KVS_KEY = ?";
        jdbcTemplate.update(sql, keyValueStore.getValue(), keyValueStore.getKey());
    }

    @Override
    public KeyValueStore selectByKey(String key) {
        SqlRowSet sqlRowSet = jdbcTemplate.queryForRowSet("SELECT * FROM UTL_KEY_VALUE_STORE WHERE KVS_KEY = ?", key);
        if (sqlRowSet.next())
            return convert(sqlRowSet);
        return null;
    }

    @Override
    public List<KeyValueStore> selectByCriteria(KeyValueStoreCriteria criteria) {
        StringBuffer sql = new StringBuffer("SELECT * FROM UTL_KEY_VALUE_STORE ");
        List<Object> params = OracleUtils.combinationSql(sql, transferCriteria(criteria), "KVS_KEY", false);
        SqlRowSet sqlRowSet = jdbcTemplate.queryForRowSet(sql.toString(), params.toArray());
        List<KeyValueStore> keyValueStoreList = new ArrayList<>();
        while (sqlRowSet.next()) {
            keyValueStoreList.add(convert(sqlRowSet));
        }
        return keyValueStoreList;
    }

    @Override
    public List<KeyValueStore> selectByCriteriaPage(KeyValueStoreCriteria criteria, int pageIndex, int pageSize) {
        StringBuffer sql = new StringBuffer("SELECT * FROM UTL_KEY_VALUE_STORE ");
        List<Object> params = OracleUtils.combinationSql(sql, transferCriteria(criteria), pageIndex, pageSize, "KVS_KEY", false);
        SqlRowSet sqlRowSet = jdbcTemplate.queryForRowSet(sql.toString(), params.toArray());
        List<KeyValueStore> keyValueStoreList = new ArrayList<>();
        while (sqlRowSet.next()) {
            keyValueStoreList.add(convert(sqlRowSet));
        }
        return keyValueStoreList;
    }

    @Override
    public int selectByCriteriaCount(KeyValueStoreCriteria criteria) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) FROM UTL_KEY_VALUE_STORE ");
        List<Object> params = OracleUtils.combinationSql(sql, transferCriteria(criteria));
        return jdbcTemplate.queryForObject(sql.toString(), params.toArray(), int.class);
    }

    @Override
    public boolean judgeKeyRepeat(String key) {
        SqlRowSet sqlRowSet = jdbcTemplate.queryForRowSet("SELECT * FROM UTL_KEY_VALUE_STORE WHERE KVS_KEY = ?", key);
        return sqlRowSet.next();
    }

    private Map<String, Object> transferCriteria(KeyValueStoreCriteria criteria) {
        Map<String, Object> andMap = new HashMap<>();
        if(StringUtils.isNotBlank(criteria.getKey())) {
            andMap.put(" KVS_KEY LIKE ?", "%" + criteria.getKey() + "%");
        }
        if(StringUtils.isNotBlank(criteria.getPrefix())) {
            andMap.put(" KVS_KEY LIKE ?", criteria.getPrefix() + "%");
        }
        return andMap;
    }


    private KeyValueStore convert(SqlRowSet sqlRowSet) {
        return new KeyValueStore(
                sqlRowSet.getString("KVS_KEY"),
                sqlRowSet.getString("KVS_VALUE")
        );
    }
}
