package com.infoepoch.pms.dispatchassistant.domain.system.moaLog;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.infoepoch.pms.dispatchassistant.common.component.AbstractCriteria;

import java.util.Date;

/**
* MOA日志记录表查询条件类
*/
public class MoaLogCriteria extends AbstractCriteria {

    //region 类型
    public boolean byType() {
        return this.andMap.containsKey("Type");
    }

    private String type;

    public String getType() {
        if (byType())
            return type;
        return null;
    }

    public void setType(String value) {
        this.type = value;
        this.andMap.put("Type", value);
    }
    //endregion

    //region 业务模块
    public boolean byBusinessModule() {
        return this.andMap.containsKey("BusinessModule");
    }

    private String businessModule;

    public String getBusinessModule() {
        if (byBusinessModule())
            return businessModule;
        return null;
    }

    public void setBusinessModule(String value) {
        this.businessModule = value;
        this.andMap.put("BusinessModule", value);
    }
    //endregion

    //region 业务模块模糊查询
    public boolean byBusinessModuleContain() {
        return this.andMap.containsKey("BusinessModuleContain");
    }

    private String businessModuleContain;

    public String getBusinessModuleContain() {
        if (byBusinessModuleContain())
            return businessModuleContain;
        return null;
    }

    public void setBusinessModuleContain(String value) {
        this.businessModuleContain = value;
        this.andMap.put("BusinessModuleContain", value);
    }
    //endregion

    //region url地址模糊查询
    public boolean byUrlContain() {
        return this.andMap.containsKey("UrlContain");
    }

    private String urlContain;

    public String getUrlContain() {
        if (byUrlContain())
            return urlContain;
        return null;
    }

    public void setUrlContain(String value) {
        this.urlContain = value;
        this.andMap.put("UrlContain", value);
    }
    //endregion

    //region 处理标识：1-处理成功 0-处理失败
    public boolean byActionFlag() {
        return this.andMap.containsKey("ActionFlag");
    }

    private Boolean actionFlag;

    public Boolean getActionFlag() {
        if (byActionFlag())
            return actionFlag;
        return null;
    }

    public void setActionFlag(Boolean value) {
        this.actionFlag = value;
        this.andMap.put("ActionFlag", value);
    }
    //endregion

    //region 当前登录用户ID
    public boolean byUserId() {
        return this.andMap.containsKey("UserId");
    }

    private String userId;

    public String getUserId() {
        if (byUserId())
            return userId;
        return null;
    }

    public void setUserId(String value) {
        this.userId = value;
        this.andMap.put("UserId", value);
    }
    //endregion

    //region 当前登录用户名称
    public boolean byUserName() {
        return this.andMap.containsKey("UserName");
    }

    private String userName;

    public String getUserName() {
        if (byUserName())
            return userName;
        return null;
    }

    public void setUserName(String value) {
        this.userName = value;
        this.andMap.put("UserName", value);
    }
    //endregion

    //region 当前登录用户名称模糊查询
    public boolean byUserNameContain() {
        return this.andMap.containsKey("UserNameContain");
    }

    private String userNameContain;

    public String getUserNameContain() {
        if (byUserNameContain())
            return userNameContain;
        return null;
    }

    public void setUserNameContain(String value) {
        this.userNameContain = value;
        this.andMap.put("UserNameContain", value);
    }
    //endregion

    // region domainId

    private String domainId;

    public String getDomainId() {
        return domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    // endregion domainId

    // region 流程步骤

    private String stage;

    public String getStage() {
        return stage;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    // endregion 流程步骤

    // region 创建时间

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createTime;

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    // endregion 创建时间

}
