package com.infoepoch.pms.dispatchassistant.domain.oa.user;


import com.infoepoch.pms.dispatchassistant.common.component.AbstractCriteria;

import java.util.List;

/**
* OA用户PMS查询条件类
*/
public class UserPmsCriteria extends AbstractCriteria {

    // region reference3列表

    private List<String> reference3List;

    public List<String> getReference3List() {
        return reference3List;
    }

    public void setReference3List(List<String> reference3List) {
        this.reference3List = reference3List;
    }

    // endregion reference3列表

    // region 员工编号列表

    private List<String> employeeNumberList;

    public List<String> getEmployeeNumberList() {
        return employeeNumberList;
    }

    public void setEmployeeNumberList(List<String> employeeNumberList) {
        this.employeeNumberList = employeeNumberList;
    }

    // endregion 员工编号列表

    //region 员工编号
    public boolean byEmployeeNumber() {
        return this.andMap.containsKey("EmployeeNumber");
    }

    private String employeeNumber;

    public String getEmployeeNumber() {
        if (byEmployeeNumber())
            return employeeNumber;
        return null;
    }

    public void setEmployeeNumber(String value) {
        this.employeeNumber = value;
        this.andMap.put("EmployeeNumber", value);
    }
    //endregion

    //region 是否领导Y:N
    public boolean byReference5() {
        return this.andMap.containsKey("Reference5");
    }

    private String reference5;

    public String getReference5() {
        if (byReference5())
            return reference5;
        return null;
    }

    public void setReference5(String value) {
        this.reference5 = value;
        this.andMap.put("Reference5", value);
    }
    //endregion

    //region 变更类型（1：新增；0：修改）
    public boolean byUpdatetype() {
        return this.andMap.containsKey("Updatetype");
    }

    private Integer updatetype;

    public Integer getUpdatetype() {
        if (byUpdatetype())
            return updatetype;
        return null;
    }

    public void setUpdatetype(Integer value) {
        this.updatetype = value;
        this.andMap.put("Updatetype", value);
    }
    //endregion

}