package com.infoepoch.pms.dispatchassistant.domain.langchain.chat.chat;



import com.infoepoch.pms.dispatchassistant.common.exception.ValidationException;
import com.infoepoch.pms.dispatchassistant.domain.langchain.chat.ChatBaseRequest;
import com.infoepoch.pms.dispatchassistant.domain.langchain.chat.History;
import io.micrometer.core.instrument.util.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * LLM 模型问答请求
 */
public class ChatRequest extends ChatBaseRequest {

    /**
     * 添加历史记录
     *
     * @param role
     * @param content
     */
    public void addHistory(String role, String content) {
        if (StringUtils.isBlank(role))
            throw new ValidationException("角色不可为空");
//        if (StringUtils.isBlank(content))
//            throw new ValidationException("内容不可为空");
        if (this.history == null)
            this.history = new ArrayList<>();
        History history = new History(
                role,
                content
        );
        this.history.add(history);
        this.historyLen = this.history.size();
    }

    /**
     * 校验
     */
    public void verify() {
        // 查询语句不可为空
        if (this.query == null || this.query.isEmpty())
            throw new ValidationException("查询语句不可为空");
        // 历史记录如果为null则置为空列表
        if (this.history == null) {
            this.history = new ArrayList<>();
            this.historyLen = 0;
        }
        // 历史记录长度不可超过1000
        if (this.historyLen > 1000)
            throw new ValidationException("历史记录长度不可超过1000");
        //
        if (this.stream == null)
            this.stream = false;
        //
        if (this.modelName == null || this.modelName.isEmpty())
            throw new ValidationException("模型名称不可为空");
        //
        if (this.temperature == null)
            throw new ValidationException("temperature不可为空");
        //
        if (this.maxTokens == null)
            throw new ValidationException("最大字数不可为空");
        //
        if (this.promptName == null || this.promptName.isEmpty())
            throw new ValidationException("提示词名称不可为空");
    }

    /**
     * 转换成 Map
     *
     * @return
     */
    public Map<String, Object> toMap() {
        // 转换成MAP前先进行校验
        this.verify();
        Map<String, Object> param = new HashMap<>();
        param.put("query", this.query);
        param.put("conversation_id", this.conversationId == null ? "1" : this.conversationId);
        param.put("history_len", this.historyLen);
        param.put("history", this.history);
        param.put("stream", this.stream);
        param.put("model_name", this.modelName);
        param.put("temperature", this.temperature);
        param.put("max_tokens", this.maxTokens);
        param.put("prompt_name", this.promptName);
        return param;
    }

    /**
     * 私有化无参构造
     */
    private ChatRequest() {
    }

    /**
     * 新增
     *
     * @param query
     * @param conversationId
     * @param stream
     * @param modelName
     * @param temperature
     * @param maxTokens
     * @param promptName
     */
    public ChatRequest(String query, String conversationId, Boolean stream, String modelName, BigDecimal temperature, Integer maxTokens, String promptName) {
        this.query = query;
        this.conversationId = conversationId;
        this.stream = stream;
        this.modelName = modelName;
        this.temperature = temperature;
        this.maxTokens = maxTokens;
        this.promptName = promptName;
    }

    /**
     * 查询语句
     */
    private String query;
    /**
     * 对话ID
     */
    private String conversationId;
    /**
     * 历史记录长度
     */
    private Integer historyLen;
    /**
     * 历史记录
     */
    private List<History> history;
    /**
     * 是否启用流式输出
     */
    private Boolean stream;
    /**
     * 模型名称
     */
    private String modelName;
    /**
     *
     */
    private BigDecimal temperature;
    /**
     * 最大字数
     */
    private Integer maxTokens;
    /**
     * 提示词名称
     */
    private String promptName;

    public String getQuery() {
        return query;
    }

    public String getConversationId() {
        return conversationId;
    }

    public Integer getHistoryLen() {
        return historyLen;
    }

    public List<History> getHistory() {
        return history;
    }

    public Boolean getStream() {
        return stream;
    }

    public String getModelName() {
        return modelName;
    }

    public BigDecimal getTemperature() {
        return temperature;
    }

    public Integer getMaxTokens() {
        return maxTokens;
    }

    public String getPromptName() {
        return promptName;
    }
}
