package com.infoepoch.pms.dispatchassistant.domain.basic.user.organizationRela;


import com.infoepoch.pms.dispatchassistant.common.component.AbstractCriteria;

import java.util.List;

/**
 * 用户与组织关联表查询条件类
 */
public class UserOrganizationRelaCriteria extends AbstractCriteria {

    //region 用户ID
    public boolean byUserId() {
        return this.andMap.containsKey("UserId");
    }

    private String userId;

    public String getUserId() {
        if (byUserId())
            return userId;
        return null;
    }

    public void setUserId(String value) {
        this.userId = value;
        this.andMap.put("UserId", value);
    }
    //endregion

    //region 组织ID
    public boolean byOrganizationId() {
        return this.andMap.containsKey("OrganizationId");
    }

    private String organizationId;

    public String getOrganizationId() {
        if (byOrganizationId())
            return organizationId;
        return null;
    }

    public void setOrganizationId(String value) {
        this.organizationId = value;
        this.andMap.put("OrganizationId", value);
    }
    //endregion

    //region 用户岗位模糊查询
    public boolean byPositionContain() {
        return this.andMap.containsKey("PositionContain");
    }

    private String positionContain;

    public String getPositionContain() {
        if (byPositionContain())
            return positionContain;
        return null;
    }

    public void setPositionContain(String value) {
        this.positionContain = value;
        this.andMap.put("PositionContain", value);
    }
    //endregion

    //region 是否为主岗
    public boolean byMajorPositionFlag() {
        return this.andMap.containsKey("MajorPositionFlag");
    }

    private Boolean majorPositionFlag;

    public Boolean getMajorPositionFlag() {
        if (byMajorPositionFlag())
            return majorPositionFlag;
        return null;
    }

    public void setMajorPositionFlag(Boolean value) {
        this.majorPositionFlag = value;
        this.andMap.put("MajorPositionFlag", value);
    }
    //endregion

    // region 账号（LIKE）

    private String username;

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    // endregion 账号（LIKE）

    // region 用户名称（LIKE）

    private String nameContain;

    public String getNameContain() {
        return nameContain;
    }

    public void setNameContain(String nameContain) {
        this.nameContain = nameContain;
    }

    // endregion 用户名称（LIKE）

    // region 组织名称（LIKE）

    private String orgNameContain;

    public String getOrgNameContain() {
        return orgNameContain;
    }

    public void setOrgNameContain(String orgNameContain) {
        this.orgNameContain = orgNameContain;
    }

    // endregion 组织名称（LIKE）

    public boolean byEmployeeNumberList(){return andMap.containsKey("EmployeeNumberList");}
    private List<String> employeeNumberList;

    public List<String> getEmployeeNumberList() {
        if (byEmployeeNumberList())
            return employeeNumberList;
        return null;
    }

    public void setEmployeeNumberList(List<String> employeeNumberList) {
        this.employeeNumberList = employeeNumberList;
        this.andMap.put("EmployeeNumberList", employeeNumberList);
    }
}