package com.infoepoch.pms.dispatchassistant.domain.basic.todo;

import com.infoepoch.pms.dispatchassistant.common.enums.EnumBase;

/**
 * 待办紧急程度
 */
public enum TodoLevel implements EnumBase {

    NORMAL(0, "一般"),
    URGENT(1, "急"),
    EXTRA_URGENT(2, "特急");

    private int value;
    private String text;

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getText() {
        return text;
    }

    TodoLevel(int value, String text) {
        this.value = value;
        this.text = text;
    }
}
