package com.infoepoch.pms.dispatchassistant.domain.basic.store;

import java.util.List;

/**
 * 键值对仓库数据库操作接口
 */
public interface IKeyValueStoreRepository {

    /**
     * 新增键值对
     *
     * @param keyValueStore
     */
    void insert(KeyValueStore keyValueStore);

    /**
     * 更新键值对
     *
     * @param keyValueStore
     */
    void update(KeyValueStore keyValueStore);

    /**
     * 查询键值对
     *
     * @param key
     * @return
     */
    KeyValueStore selectByKey(String key);

    /**
     * 查询列表
     *
     * @param criteria
     * @return
     */
    List<KeyValueStore> selectByCriteria(KeyValueStoreCriteria criteria);

    /**
     * 分页查询列表
     * @param criteria
     * @return
     */
    List<KeyValueStore> selectByCriteriaPage(KeyValueStoreCriteria criteria, int pageIndex, int pageSize);

    /**
     * 查询总数量
     *
     * @param criteria
     * @return
     */
    int selectByCriteriaCount(KeyValueStoreCriteria criteria);

    /**
     * 判断key是否重复
     * true-重复 false-未重复
     *
     * @param key
     * @return
     */
    boolean judgeKeyRepeat(String key);

}
