package com.infoepoch.pms.dispatchassistant.domain.basic.menu;



import com.infoepoch.pms.dispatchassistant.common.component.SnowFlake;

import java.util.Date;
import java.util.List;

/**
 * @author xuyj
 * @description 菜单
 * @date 2019-11-13 16:49
 */
public class Menu {

    public void modifyUrl(String url) {
        this.url = url;
    }

    /**
     * 菜单类型区分
     */
    public static final int TYPE_MENU_MAIN = 1;
    public static final int TYPE_MENU_COOP = 2;

    public static final int ELEMENT_MENU = 0;
    public static final int ELEMENT_BUTTON = 1;

    private String id;
    private String name;
    private String url;
    /**
     * @JsonProperty 解决ztree重名问题
     */
    private String icons;
    /**
     * 是否折叠
     */
    private boolean collapse;
    /**
     * 是否禁用
     */
    private boolean disabled;
    private String description;
    private String parentId;
    /**
     * 0菜单 1按钮
     */
    private int element;
    /**
     * 排序字段
     */
    private int sorting;
    private Date createTime;
    private Date modifyTime;
    /**
     * 1用户 2供应商
     */
    private int type;

    private List<Menu> children;

    /**
     * 是否角色关联
     */
    private boolean checked;

    /**
     * 是否进行数据管控
     */
    private boolean controlData;

    private String invoice;

    public Menu() {
    }

    public Menu(String id, String name, String parentId) {
        this.id = id;
        this.name = name;
        this.parentId = parentId;
    }

    public Menu(String id, String name, String url, String icon, boolean collapse, boolean disabled, String description, String parentId, int element, int sorting, Date createTime, Date modifyTime, int type, boolean controlData) {
        this.id = id;
        this.name = name;
        this.url = url;
        this.icons = icon;
        this.collapse = collapse;
        this.disabled = disabled;
        this.description = description;
        this.parentId = parentId;
        this.element = element;
        this.sorting = sorting;
        this.createTime = createTime;
        this.modifyTime = modifyTime;
        this.type = type;
        this.controlData = controlData;
    }

    public Menu create() {
        this.id = String.valueOf(SnowFlake.instant().nextId());
        this.createTime = new Date();
        this.element = ELEMENT_MENU;
        return this;
    }

    public String getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getUrl() {
        return url;
    }

    public String getIcons() {
        return icons;
    }

    public boolean isCollapse() {
        return collapse;
    }

    public boolean isDisabled() {
        return disabled;
    }

    public String getDescription() {
        return description;
    }

    public String getParentId() {
        return parentId;
    }

    public int getElement() {
        return element;
    }

    public int getSorting() {
        return sorting;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public int getType() {
        return type;
    }

    public List<Menu> getChildren() {
        return children;
    }

    public void setChildren(List<Menu> children) {
        this.children = children;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public boolean isChecked() {
        return checked;
    }

    public boolean isControlData() {
        return controlData;
    }

    public void setInvoice(String invoice) {
        this.invoice = invoice;
    }

    public String getInvoice() {
        return invoice;
    }
}
