package com.infoepoch.pms.dispatchassistant.controller.system;

import com.infoepoch.pms.dispatchassistant.common.component.Result;
import com.infoepoch.pms.dispatchassistant.common.encryption.AESTool;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 加密/解密相关控制层
 */
@RestController
@RequestMapping("/api/encryption")
public class EncryptionController {

    /**
     * 加密
     *
     * @param str
     * @return
     */
    @PostMapping("/encode")
    public Result encode(String str) {
        return Result.successData(AESTool.getEncryptString(str));
    }

    /**
     * 解密
     *
     * @param str
     * @return
     */
    @PostMapping("/decode")
    public Result decode(String str) {
        return Result.successData(AESTool.getDecryptString(str));
    }

}
