package com.infoepoch.pms.dispatchassistant.controller.system;

import com.infoepoch.pms.dispatchassistant.common.component.Result;
import com.infoepoch.pms.dispatchassistant.common.exception.NotLoginException;
import com.infoepoch.pms.dispatchassistant.domain.system.dict.DictTypeService;
import com.infoepoch.pms.dispatchassistant.domain.system.dict.SystemDictCriteria;
import com.infoepoch.pms.dispatchassistant.domain.system.dict.SystemDictType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/dict-type")
public class DictTypeController {

    @Autowired
    private DictTypeService dictTypeService;

    /**
     * 列表
     *
     * @param criteria
     * @return
     */
    @PostMapping("/list")
    public Result list(@RequestBody SystemDictCriteria criteria) {
        return Result.successData(dictTypeService.pageList(criteria));
    }

    /**
     * 详情
     *
     * @param id
     * @return
     */
    @GetMapping("/detail/{id}")
    public Result detail(@PathVariable("id") String id) {
        return Result.successData(dictTypeService.detailById(id));
    }

    /**
     * 保存
     *
     * @param dictType
     * @return
     * @throws NotLoginException
     */
    @PostMapping("/save")
    public Result save(@RequestBody SystemDictType dictType) throws NotLoginException {
        dictTypeService.save(dictType);
        return Result.success();
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @GetMapping("/remove/{id}")
    public Result remove(@PathVariable("id") String id) {
        dictTypeService.removeById(id);
        return Result.success();
    }

}
