package com.infoepoch.pms.dispatchassistant.common.component;

import org.apache.commons.lang3.StringUtils;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractCriteria {
    private Integer pageIndex;
    private Integer pageSize;

    public Integer getPageIndex() {
        return pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public boolean byPage() {
        if (pageIndex == null || pageSize == null)
            return false;
        if (pageIndex < 0 || pageSize < 1)
            return false;
        return true;
    }

    /*** andMap*/
    protected Map<String, Object> andMap = new LinkedHashMap<>();

    /*** 是否有查询条件*/
    public boolean hasCriteria() {
        return !andMap.isEmpty();
    }

    /**
     * @Description: 移除andMap内value为null或空字符串
     * @Param: []
     * @Author: zhangyd
     */
    public void removeMapNullOrEmpty() {
        Iterator<Map.Entry<String, Object>> it = andMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            if (entry.getValue() == null) {
                it.remove();
                continue;
            }
            //如果是字符串，判断是否是空字符串
            if ((entry.getValue() instanceof String) && StringUtils.isBlank(entry.getValue().toString())) {
                it.remove();
            }
        }
    }

    /**
     * @Description: 移除andMap内value为null或空字符串
     * @Param: []
     * @Author: zhangyd
     */
    public void removeMapNull() {
        Iterator<Map.Entry<String, Object>> it = andMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            if (entry.getValue() == null) {
                it.remove();
            }
        }
    }

}