/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.extend.datatype;

import com.oceanbase.jdbc.extend.datatype.Datum;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMP;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

public class TIMESTAMPTZ
extends Datum {
    public static int HOUR_MILLISECOND;
    public static int MINUTE_MILLISECOND;
    public static int SIZE_TIMESTAMPTZ;

    public TIMESTAMPTZ() {
        super(TIMESTAMPTZ.initTimestamptz());
    }

    public TIMESTAMPTZ(byte[] bytes) {
        super(bytes);
    }

    public TIMESTAMPTZ(Connection connection, Date date) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, date));
    }

    public TIMESTAMPTZ(Connection connection, Date date, Calendar calendar) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, date, calendar));
    }

    public TIMESTAMPTZ(Connection connection, Time time) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, time));
    }

    public TIMESTAMPTZ(Connection connection, Time time, Calendar calendar) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, time, calendar));
    }

    public TIMESTAMPTZ(Connection connection, Timestamp timestamp) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, timestamp));
    }

    public TIMESTAMPTZ(Connection connection, Timestamp timestamp, Calendar calendar) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, timestamp, calendar));
    }

    public TIMESTAMPTZ(Connection connection, Timestamp timestamp, Calendar calendar, boolean isTZTablesImported) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, timestamp, calendar, isTZTablesImported));
    }

    public TIMESTAMPTZ(Connection connection, String time) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, time));
    }

    public TIMESTAMPTZ(Connection connection, String time, Calendar calendar) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, time, calendar));
    }

    public static Date toDate(byte[] bytes) throws SQLException {
        if (bytes.length < 14) {
            throw new SQLException("invalid bytes length");
        }
        String tzStr = TIMESTAMPTZ.toTimezoneStr(bytes[12], bytes[13], "GMT", true);
        Calendar targetCalendar = Calendar.getInstance(TimeZone.getTimeZone(tzStr));
        Date date = new Date(TIMESTAMPTZ.getOriginTime(bytes, TimeZone.getTimeZone(tzStr)));
        targetCalendar.setTime(date);
        date.setTime(targetCalendar.getTime().getTime());
        return date;
    }

    public static Time toTime(Connection connection, byte[] bytes) throws SQLException {
        if (bytes.length < 14) {
            throw new SQLException("invalid bytes length");
        }
        String tzStr = TIMESTAMPTZ.toTimezoneStr(bytes[12], bytes[13], "GMT", true);
        Time time = new Time(TIMESTAMPTZ.getOriginTime(bytes, TimeZone.getTimeZone(tzStr), true));
        return time;
    }

    public static TIMESTAMP toTIMESTAMP(Protocol protocol, byte[] bytes) throws SQLException {
        return new TIMESTAMP(TIMESTAMPTZ.toTimestamp(protocol, bytes));
    }

    public static TIMESTAMP resultTIMESTAMP(Protocol protocol, byte[] bytes) throws SQLException {
        return new TIMESTAMP(TIMESTAMPTZ.toTimestamp(protocol, bytes, true));
    }

    public static TIMESTAMP toTIMESTAMP(Connection connection, byte[] bytes) throws SQLException {
        return new TIMESTAMP(TIMESTAMPTZ.toTimestamp(connection, bytes));
    }

    @Override
    public Date dateValue() throws SQLException {
        return TIMESTAMPTZ.toDate(this.getBytes());
    }

    public Date dateValue(Connection conn) throws SQLException {
        return TIMESTAMPTZ.toDate(this.getBytes());
    }

    @Override
    public Time timeValue() throws SQLException {
        return TIMESTAMPTZ.toTime(null, this.getBytes());
    }

    public static Timestamp toTimestamp(Protocol protocol, byte[] bytes) throws SQLException {
        if (bytes.length < 14) {
            throw new SQLException("invalid bytes length");
        }
        String tzStr = TIMESTAMPTZ.toTimezoneStr(bytes[12], bytes[13], "GMT", true);
        Timestamp timestamp = new Timestamp(TIMESTAMPTZ.getOriginTime(bytes, TimeZone.getTimeZone(tzStr)));
        timestamp.setNanos(TIMESTAMP.getNanos(bytes, 7));
        return timestamp;
    }

    public static Timestamp toTimestamp(Protocol protocol, byte[] bytes, boolean isResult) throws SQLException {
        if (bytes.length < 14) {
            throw new SQLException("invalid bytes length");
        }
        String tzStr = TIMESTAMPTZ.toTimezoneStr(bytes[12], bytes[13], "GMT", isResult);
        Timestamp timestamp = null;
        timestamp = new Timestamp(TIMESTAMPTZ.getOriginTime(bytes, TimeZone.getTimeZone(tzStr), !isResult));
        timestamp.setNanos(TIMESTAMP.getNanos(bytes, 7));
        return timestamp;
    }

    public static Timestamp toTimestamp(Connection connection, byte[] bytes) throws SQLException {
        if (bytes.length < 14) {
            throw new SQLException("invalid bytes length");
        }
        String tzStr = TIMESTAMPTZ.toTimezoneStr(bytes[12], bytes[13], "GMT", true);
        Timestamp timestamp = new Timestamp(TIMESTAMPTZ.getOriginTime(bytes, TimeZone.getTimeZone(tzStr)));
        timestamp.setNanos(TIMESTAMP.getNanos(bytes, 7));
        return timestamp;
    }

    public static long getOriginTime(byte[] bytes, TimeZone timeZone, boolean isTSResult) throws SQLException {
        int i;
        if (bytes.length < 7) {
            throw new SQLException("invalid bytes length");
        }
        int[] result = new int[7];
        for (i = 0; i < 7; ++i) {
            result[i] = bytes[i] & 0xFF;
        }
        i = result[0] * 100 + result[1];
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.clear();
        if (!isTSResult) {
            calendar.set(1, i);
            calendar.set(2, result[2] - 1);
            calendar.set(5, result[3]);
        } else {
            calendar.set(1, 1970);
            calendar.set(2, 0);
            calendar.set(5, 1);
        }
        calendar.set(11, result[4]);
        calendar.set(12, result[5]);
        calendar.set(13, result[6]);
        return calendar.getTimeInMillis();
    }

    public static long getOriginTime(byte[] bytes, TimeZone timeZone) throws SQLException {
        return TIMESTAMPTZ.getOriginTime(bytes, timeZone, false);
    }

    public static String toString(Connection connection, byte[] bytes, boolean isResult) throws SQLException {
        if (bytes.length < 14) {
            throw new SQLException("invalid bytes length");
        }
        String tzStr = null;
        byte tzNameLen = 0;
        tzNameLen = bytes.length == 14 ? (byte)0 : bytes[14];
        if (tzNameLen != 0) {
            byte[] tmp = new byte[tzNameLen];
            System.arraycopy(bytes, 15, tmp, 0, tzNameLen);
            String tzName = new String(tmp);
            byte abbrLen = bytes[15 + tzNameLen];
            tzStr = tzName;
        } else {
            tzStr = TIMESTAMPTZ.toTimezoneStr(bytes[12], bytes[13], "", isResult);
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(tzStr));
        calendar.setTimeInMillis(TIMESTAMPTZ.getOriginTime(bytes, TimeZone.getTimeZone(tzStr)));
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int nanos = TIMESTAMP.getNanos(bytes, 7);
        return TIMESTAMPTZ.toString(year, month, day, hour, minute, second, nanos, bytes[11], tzStr);
    }

    public String toResultSetString(Connection connection) throws SQLException {
        return TIMESTAMPTZ.toString(connection, this.getBytes(), true);
    }

    public static final String toString(int year, int month, int day, int hour, int minute, int second, int nanos, int scale, String timezone) {
        String time = "" + year + "-" + TIMESTAMPTZ.toStr(month) + "-" + TIMESTAMPTZ.toStr(day) + " " + TIMESTAMPTZ.toStr(hour) + ":" + TIMESTAMPTZ.toStr(minute) + ":" + TIMESTAMPTZ.toStr(second);
        if (nanos >= 0) {
            int index;
            String temp = String.format("%09d", nanos);
            char[] chars = temp.toCharArray();
            for (index = chars.length; index > 1 && chars[index - 1] == '0'; --index) {
            }
            temp = temp.substring(0, index);
            time = time + "." + temp;
        }
        if (timezone != null) {
            time = time + " " + timezone;
        }
        return time;
    }

    private static final String toStr(int temp) {
        return temp < 10 ? "0" + temp : Integer.toString(temp);
    }

    public Timestamp timestampValue(Connection connection) throws SQLException {
        return TIMESTAMPTZ.toTimestamp(connection, this.getBytes());
    }

    @Override
    public Timestamp timestampValue() throws SQLException {
        return TIMESTAMPTZ.toTimestamp((Connection)null, this.getBytes());
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(Connection connection, Date date) throws SQLException {
        return TIMESTAMPTZ.toBytes(connection, date, null);
    }

    public static byte[] toBytes(Connection connection, Date date, Calendar calendar) throws SQLException {
        if (date == null) {
            return null;
        }
        if (null == calendar) {
            calendar = Calendar.getInstance();
        }
        Calendar localCalendar = Calendar.getInstance();
        byte[] resultBytes = new byte[SIZE_TIMESTAMPTZ];
        int offset = calendar.getTimeZone().getRawOffset();
        localCalendar.setTime(date);
        int year = calendar.get(1);
        if (year >= -4712 && year <= 9999) {
            resultBytes[0] = (byte)(localCalendar.get(1) / 100);
            resultBytes[1] = (byte)(localCalendar.get(1) % 100);
            resultBytes[2] = (byte)(localCalendar.get(2) + 1);
            resultBytes[3] = (byte)localCalendar.get(5);
            resultBytes[4] = 0;
            resultBytes[5] = 0;
            resultBytes[6] = 0;
            TIMESTAMP.setNanos(resultBytes, 7, 0);
            resultBytes[12] = (byte)(offset / HOUR_MILLISECOND);
            resultBytes[13] = (byte)(offset < 0 ? -offset % HOUR_MILLISECOND / MINUTE_MILLISECOND : offset % HOUR_MILLISECOND / MINUTE_MILLISECOND);
            return resultBytes;
        }
        throw new SQLException(String.format("error format, timestamp = %s", date.toString()), "268");
    }

    public static byte[] toBytes(Connection connection, Time time) throws SQLException {
        return TIMESTAMPTZ.toBytes(connection, time, null);
    }

    public static byte[] toBytes(Connection connection, Time time, Calendar calendar) throws SQLException {
        if (time == null) {
            return null;
        }
        if (null == calendar) {
            calendar = Calendar.getInstance();
        }
        Calendar localCalendar = Calendar.getInstance();
        byte[] resultBytes = new byte[SIZE_TIMESTAMPTZ];
        int offset = calendar.getTimeZone().getRawOffset();
        localCalendar.setTime(time);
        int base = 1970;
        localCalendar.set(1, base);
        localCalendar.set(2, 0);
        localCalendar.set(5, 1);
        int year = calendar.get(1);
        if (year >= -4712 && year <= 9999) {
            resultBytes[0] = (byte)(localCalendar.get(1) / 100);
            resultBytes[1] = (byte)(localCalendar.get(1) % 100);
            resultBytes[2] = (byte)(localCalendar.get(2) + 1);
            resultBytes[3] = (byte)localCalendar.get(5);
            resultBytes[4] = (byte)localCalendar.get(11);
            resultBytes[5] = (byte)localCalendar.get(12);
            resultBytes[6] = (byte)localCalendar.get(13);
            TIMESTAMP.setNanos(resultBytes, 7, 0);
            resultBytes[12] = (byte)(offset / HOUR_MILLISECOND);
            resultBytes[13] = (byte)(offset < 0 ? -offset % HOUR_MILLISECOND / MINUTE_MILLISECOND : offset % HOUR_MILLISECOND / MINUTE_MILLISECOND);
            return resultBytes;
        }
        throw new SQLException(String.format("error format, timestamp = %s", time.toString()), "268");
    }

    public static byte[] toBytes(Connection connection, Timestamp timeStamp) throws SQLException {
        return TIMESTAMPTZ.toBytes(connection, timeStamp, null);
    }

    public static TIMESTAMPTZ toTIMESTAMPTZ(Timestamp timestamp, String timeZoneStr) throws SQLException {
        if (timestamp == null) {
            return null;
        }
        if (timeZoneStr == null || timeZoneStr.isEmpty()) {
            throw new SQLException("illegal time zone");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        calendar.setTimeZone(TimeZone.getTimeZone(timeZoneStr));
        byte[] resultBytes = new byte[SIZE_TIMESTAMPTZ];
        int offset = calendar.getTimeZone().getRawOffset();
        int year = calendar.get(1);
        if (year < -4712 || year > 9999) {
            throw new SQLException(String.format("error format, timestamp = %s", timestamp.toString()), "268");
        }
        resultBytes[0] = (byte)(calendar.get(1) / 100);
        resultBytes[1] = (byte)(calendar.get(1) % 100);
        resultBytes[2] = (byte)(calendar.get(2) + 1);
        resultBytes[3] = (byte)calendar.get(5);
        resultBytes[4] = (byte)calendar.get(11);
        resultBytes[5] = (byte)calendar.get(12);
        resultBytes[6] = (byte)calendar.get(13);
        TIMESTAMP.setNanos(resultBytes, 7, timestamp.getNanos());
        resultBytes[12] = (byte)(offset / HOUR_MILLISECOND);
        resultBytes[13] = (byte)(offset < 0 ? -offset % HOUR_MILLISECOND / MINUTE_MILLISECOND : offset % HOUR_MILLISECOND / MINUTE_MILLISECOND);
        return new TIMESTAMPTZ(resultBytes);
    }

    public static byte[] toBytes(Connection connection, Timestamp timestamp, Calendar calendar) throws SQLException {
        return TIMESTAMPTZ.toBytes(connection, timestamp, calendar, false);
    }

    public static byte[] toBytes(Connection connection, Timestamp timestamp, Calendar calendar, boolean isTZTablesImported) throws SQLException {
        if (timestamp == null) {
            return null;
        }
        if (null == calendar) {
            calendar = Calendar.getInstance();
        }
        Calendar localCalendar = Calendar.getInstance();
        String tz = calendar.getTimeZone().getID();
        boolean isGMT = false;
        if (tz.startsWith("GMT")) {
            tz = tz.substring(3);
            isGMT = true;
        }
        int tzLen = tz.length();
        byte[] resultBytes = null;
        resultBytes = isTZTablesImported ? new byte[SIZE_TIMESTAMPTZ + tzLen + 2] : new byte[SIZE_TIMESTAMPTZ + 2];
        int offset = calendar.getTimeZone().getRawOffset();
        localCalendar.setTime(timestamp);
        int year = localCalendar.get(1);
        if (year >= -4712 && year <= 9999) {
            resultBytes[0] = (byte)(localCalendar.get(1) / 100);
            resultBytes[1] = (byte)(localCalendar.get(1) % 100);
            resultBytes[2] = (byte)(localCalendar.get(2) + 1);
            resultBytes[3] = (byte)localCalendar.get(5);
            resultBytes[4] = (byte)localCalendar.get(11);
            resultBytes[5] = (byte)localCalendar.get(12);
            resultBytes[6] = (byte)localCalendar.get(13);
            TIMESTAMP.setNanos(resultBytes, 7, timestamp.getNanos());
            resultBytes[12] = (byte)(offset / HOUR_MILLISECOND);
            resultBytes[13] = (byte)(offset < 0 ? -offset % HOUR_MILLISECOND / MINUTE_MILLISECOND : offset % HOUR_MILLISECOND / MINUTE_MILLISECOND);
            if (isTZTablesImported && !isGMT) {
                resultBytes[14] = (byte)tzLen;
                System.arraycopy(tz.getBytes(), 0, resultBytes, 15, tzLen);
                resultBytes[14 + tzLen + 1] = 0;
            } else {
                resultBytes[14] = 0;
                resultBytes[15] = 0;
            }
            return resultBytes;
        }
        throw new SQLException(String.format("error format, timestamp = %s", timestamp.toString()), "268");
    }

    public static byte[] toBytes(Connection connection, String time) throws SQLException {
        return TIMESTAMPTZ.toBytes(connection, Timestamp.valueOf(time));
    }

    public static byte[] toBytes(Connection connection, String time, Calendar calendar) throws SQLException {
        return TIMESTAMPTZ.toBytes(connection, Timestamp.valueOf(time), calendar);
    }

    @Override
    public String stringValue(Connection connection) throws SQLException {
        return TIMESTAMPTZ.toString(connection, this.getBytes(), false);
    }

    @Override
    public String stringValue() throws SQLException {
        return TIMESTAMPTZ.toString(null, this.getBytes(), false);
    }

    public Time timeValue(Connection connection) throws SQLException {
        return TIMESTAMPTZ.toTime(connection, this.getBytes());
    }

    private static byte[] initTimestamptz() {
        byte[] result = new byte[14];
        result[0] = 19;
        result[1] = 70;
        result[2] = 1;
        result[3] = 1;
        result[4] = 1;
        result[5] = 1;
        result[6] = 1;
        result[7] = 0;
        result[8] = 0;
        result[9] = 0;
        result[10] = 0;
        result[11] = 0;
        result[12] = 0;
        return result;
    }

    @Override
    public Object toJdbc() throws SQLException {
        return null;
    }

    @Override
    public Object makeJdbcArray(int temp) {
        Timestamp[] timestamps = new Timestamp[temp];
        return timestamps;
    }

    @Override
    public boolean isConvertibleTo(Class claz) {
        return claz.getName().compareTo("java.sql.Date") == 0 || claz.getName().compareTo("java.sql.Time") == 0 || claz.getName().compareTo("java.sql.Timestamp") == 0 || claz.getName().compareTo("java.lang.String") == 0;
    }

    private static int getHighOrderbits(int bits) {
        return (bits & 0x7F) << 6;
    }

    private static int getLowOrderbits(int bits) {
        return (bits & 0xFC) >> 2;
    }

    public static String toTimezoneStr(byte hour, byte minute, String pre, boolean isResult) {
        StringBuilder offsetTimeZone = new StringBuilder();
        boolean isPostive = true;
        if (hour <= -10) {
            isPostive = false;
            offsetTimeZone.append(-hour);
        } else if (hour < 0) {
            isPostive = false;
            offsetTimeZone.append(-hour);
        } else if (hour < 10) {
            offsetTimeZone.append(hour);
        } else {
            offsetTimeZone.append(hour);
        }
        offsetTimeZone.append(":");
        if (!isPostive && !isResult) {
            if (minute != 0) {
                offsetTimeZone.append("-");
            }
            if (minute <= -10) {
                isPostive = false;
                offsetTimeZone.append(-minute);
            } else if (minute < 0) {
                offsetTimeZone.append("0");
                offsetTimeZone.append(-minute);
            } else if (minute < 10) {
                offsetTimeZone.append("0");
                offsetTimeZone.append(minute);
            } else {
                offsetTimeZone.append(minute);
            }
        } else if (minute <= -10) {
            isPostive = false;
            offsetTimeZone.append(-minute);
        } else if (minute < 0) {
            isPostive = false;
            offsetTimeZone.append("0");
            offsetTimeZone.append(-minute);
        } else if (minute < 10) {
            offsetTimeZone.append("0");
            offsetTimeZone.append(minute);
        } else {
            offsetTimeZone.append(minute);
        }
        if (isResult) {
            return (pre == null ? "" : pre) + (isPostive ? "+" + offsetTimeZone : "-" + offsetTimeZone);
        }
        return (pre == null ? "" : pre) + (isPostive ? offsetTimeZone : "-" + offsetTimeZone);
    }

    static {
        SIZE_TIMESTAMPTZ = 14;
        HOUR_MILLISECOND = 3600000;
        MINUTE_MILLISECOND = 60000;
    }
}

