//流程引擎流程表达式选人
define(['jquery', 'vue', '../../libs/jquery.ztree/fuzzysearch.js', 'jquery-ztree']
    , function ($, Vue, fuzzySearch) {
        return Vue.component('peac-url-users-picker', {
            data: function () {
                return {
                    actorId: '',
                    domainId: '',
                    actorUrl: '',
                    selectedId: '',
                    selectedItems: [],
                    //已选择人员的文案
                    description: '选择人员',
                    treeId: 'tree' + Math.floor(100000000 + Math.random() * 900000000),     //生成随机id
                    searchId: 'search' + Math.floor(100000000 + Math.random() * 900000000)  //生成随机id
                }
            },
            template: '<div>\
                        <div class="peac_column peac_column_tree" style="overflow: hidden;">\
                        <div class="peac_column_title">\
                        <!--<a href="javascript:void(null);" @click="expand">展开</a>-->\
                        <!--<a href="javascript:void(null);" @click="collapse">收起</a>-->\
                        <input type="text" :id="searchId" class="form_control" placeholder="请输入搜索内容" />\
                        </div>\
                        <div class="peac_tree_container">\
                            <ul :id="treeId" class="ztree"></ul>\
                        </div>\
                    </div>\
                    <div class="peac_column peac_column_selected">\
                        <div class="peac_column_title">已选择人员</div>\
                        <div class="peac_selected_container">\
                            <div class="peac_selected_item" v-for="item in selectedItems">\
                                <div class="peac_selected_name">{{item.name}}</div>\
                                <div class="peac_selected_remove" @click="remove(item)">╳</div>\
                            </div>\
                        </div>\
                    </div>\
                    </div>',
            created: function () {
            },
            mounted: function () {
            },
            computed: {},
            methods: {
                setParams: function (actorUrl, actorId, domainId) {
                    if (actorUrl == undefined)
                        return;
                    this.actorUrl = actorUrl;
                    this.actorId = actorId;
                    this.domainId = domainId;
                    this.bindData();
                },
                bindData: function () {
                    var that = this;
                    var setting = {
                        check: {
                            enable: true,
                            chkStyle: 'checkbox',
                            radioType: 'all'
                        },
                        view: {showIcon: false},
                        callback: {
                            onClick: function (event, treeId, treeNode) {
                                var zTree = $.fn.zTree.getZTreeObj(treeId);
                                if (treeNode.isParent) {
                                    if (treeNode.open) {
                                        zTree.expandNode(treeNode, false);
                                    } else {
                                        zTree.expandNode(treeNode, true);
                                    }
                                } else {
                                    zTree.checkNode(treeNode, !treeNode.checked, true, true);
                                }
                            },
                            onCheck: function zTreeOnCheck(event, treeId, treeNode) {
                                //console.log(treeNode);
                                //console.log(treeId + ', ' + treeNode.tId + ', ' + treeNode.id + ', ' + treeNode.name + ',' + treeNode.checked);
                                var treeObj = $.fn.zTree.getZTreeObj(treeId);
                                var nodes = treeObj.getCheckedNodes(true);
                                console.log(nodes);
                                that.selectedItems = $.map(nodes, function (node, index) {
                                    if (!node.isParent) {
                                        var name = node.name;
                                        if (node.oldname)
                                            name = node.oldname;
                                        return {id: node.id, name: name};
                                    }
                                });
                            }
                        }
                    };
                    if(that.actorUrl=='')
                        return;
                    $.ajax({
                        type: 'GET',
                        url: that.actorUrl,
                        data: {actorId: that.actorId, domainId: that.domainId},
                        success: function (res) {
                                var zNodes = res.data;
                                var zTreeObj = $.fn.zTree.init($('#' + that.treeId), setting, zNodes);    //绑定树
                                fuzzySearch.fuzzySearch(that.treeId, '#' + that.searchId, true, true);
                                //自动展开第一个根节点
                                if (zTreeObj.getNodes().length > 0)
                                    zTreeObj.expandNode(zTreeObj.getNodes()[0], true);
                        }
                    });
                },
                remove: function (item) {
                    var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                    var nodes = treeObj.getCheckedNodes(true);
                    $.each(nodes, function (index, node) {
                        if (node.id == item.id)
                            treeObj.checkNode(node, false, true, true); //取消树节点选中
                    });
                    this.selectedItems = $.grep(this.selectedItems, function (selectedItem, index) {
                        return selectedItem.id != item.id;
                    });
                },
                expand: function () {
                    var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                    treeObj.expandAll(true);
                },
                collapse: function () {
                    var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                    treeObj.expandAll(false);
                },
                search: function () {
                    var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                    treeObj.fuzzySearch(false);
                },
                verifyValue: function () {
                    if (this.selectedItems.length == 0) {
                        // alert('请选择处理人。');
                        layer.confirm('请选择处理人。',
                            {title:'提示',btn: ['确定'],closeBtn: 0 },
                            function(index){
                                layer.close(index);
                            });
                        return false;
                    }
                    return true;
                },
                getValue: function () {
                    var items = $.map(this.selectedItems, function (item, index) {
                        return item.id + '::' + item.name;
                    });
                    return items;
                }
            }
        });
    });
