//流程引擎历史记录组件
define(['jquery', 'vue'], function ($, Vue) {
    return Vue.component('peac-history', {
        props: {
            histories: {
                default: function () {
                    return [];
                }
            }
        },
        data: function () {
            return {
                showSystem: true
            }
        },
        template: '\
          <div class="block_container">\
          <div>\
            <div style="float: right;">\
            <label><input type="checkbox" @click="showSystem = !showSystem" class="processv2-check" /> 显示系统活动</label>\
            </div>\
            <div class="title">审批流程\
            </div>\
            <div class="block_container">\
              \
            </div>\
            <div style="color: #333333; font-weight: normal;">\
                    <table class="table table_list table_striped text_center">\
                        <thead>\
                            <tr>\
                                <th>序号</th>\
                                <th>流程步骤</th>\
                                <th>处理人</th>\
                                <th>送达时间</th>\
                                <th>完成时间</th>\
                                <th>状态</th>\
                                <th>处理意见/结果</th>\
                            </tr>\
                        </thead>\
                        <tbody>\
                            <template v-for="(history, index) in filterHistories">\
                            <tr v-if="history.activityType != \'SubprocessBegin\' && history.activityType != \'SubprocessEnd\'">\
                                <td>{{index + 1}}</td>\
                                <td>{{history.activityName}}</td>\
                                <td>{{history.actorName}}</td>\
                                <td>{{history.beginTime}}</td>\
                                <td>{{history.finishTime}}</td>\
                                <td class="text-nowrap">{{history.actionType=="Return"?"已退回":(history.finished?"已处理":"待处理")}}</td>\
                                <td class="text-left">{{history.comment}}</td>\
                            </tr>\
                            <tr v-if="history.activityType == \'SubprocessBegin\'" style="background-image: linear-gradient(to bottom, #DDDDDD, #FFFFFF);">\
                                <td>{{index + 1}}</td>\
                                <td colspan="6">{{history.activityName}} （{{history.finished?"已结束":"未结束"}}）</td>\
                            </tr>\
                            \<tr v-if="history.activityType == \'SubprocessEnd\'" style="background-image: linear-gradient(to bottom, #FFFFFF, #DDDDDD);">\
                                <td colspan="7"></td>\
                                <!--<td>{{index + 1}}</td>\
                                <td colspan="6">{{new Array((history.activityName + "（" + (history.finished?"已结束":"未结束") + "）").length + 13).join("∧")}}</td>-->\
                            </tr>\
                            </template>\
                        </tbody>\
                    </table></div></div></div>',
        created: function () {
            //子组件中需要增加v-if判断以结束递归
        },
        mounted: function () {
        },
        watch: {},
        computed: {
            filterHistories: function () {
                if (this.showSystem) {
                    return this.histories;
                } else
                    return $.grep(this.histories, function (item, index) {
                        return item.activityType == 'Task';
                    });
            }
        },
        methods: {}
    });
});
