package com.infoepoch.pms.dispatchassistant.infractructure.expertInformation;


import com.infoepoch.pms.dispatchassistant.common.utils.OracleUtils;
import com.infoepoch.pms.dispatchassistant.domain.expertInformation.ExpertInformation;
import com.infoepoch.pms.dispatchassistant.domain.expertInformation.ExpertInformationCriteria;
import com.infoepoch.pms.dispatchassistant.domain.expertInformation.IExpertInformationRepository;
import com.infoepoch.pms.dispatchassistant.infractructure.langchain.ConversationsRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * generated by code-generator
 * 专家信息表仓储实现
 */
@Repository
public class ExpertInformationRepository implements IExpertInformationRepository {

    @Autowired
    private JdbcTemplate jdbcTemplate;

    private static final Logger LogHelper = LoggerFactory.getLogger(ConversationsRepository.class);

    /**
     * 查询表序列id
     */
    @Override
    public Long sequenceId() {
        StringBuffer buffer = new StringBuffer("SELECT SEQ_T_EXPERT_INFORMATION.NEXTVAL FROM DUAL ");
        return jdbcTemplate.queryForObject(buffer.toString(), Long.class);
    }

    /**
     * 新增
     */
    @Override
    public boolean insert(ExpertInformation entity) {
        String sql = "INSERT INTO T_EXPERT_INFORMATION(EI_ID, EI_NAME, EI_GENDER, EI_MAILBOX, EI_TELEPHONE, EI_USER_NAME, EI_EMPLOYMENT_DATE, EI_DEPARTMENT, EI_GROUP, EI_POSITION, EI_SCOPE_BUSINESS, EI_STATE, EI_SPECIALIZES_FIELDS, EI_EXPERT_INTRODUCTION, EI_ORGANIZATIONAL_CODE, EI_RECORD_TIME, EI_UPDATE_TIME, EI_PHOTO, EI_GROUP_ID, EI_DEPARTMENT_ID, EI_USER_ID, EI_SATISFACTION_SCORE, EI_LEVEL, EI_DISABLED, EI_REGION_CODE, EI_SORT) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        int result=0;
        try {
            result = jdbcTemplate.update(sql, entity.getId(), entity.getName(), entity.getGender(), entity.getMailbox(), entity.getTelephone(), entity.getUserName(), entity.getEmploymentDate(), entity.getDepartment(), entity.getGroup(), entity.getPosition(), entity.getScopeBusiness(), entity.getState(), entity.getSpecializesFields(), entity.getExpertIntroduction(), entity.getOrganizationalCode(), entity.getRecordTime(), entity.getUpdateTime(), entity.getPhoto(), entity.getGroupId(), entity.getDepartmentId(), entity.getUserId(), entity.getSatisfactionScore(), entity.getLevel(), entity.getDisabled(), entity.getRegionCode(), entity.getSort());
        } catch (Exception e) {
            LogHelper.info(e.getMessage());
            //throw new ServiceException("新增 专家信息表 数据 失败。");
        }
        return result > 0;
    }

    /**
     * 更新
     */
    @Override
    public boolean update(ExpertInformation entity) {
        String sql = "UPDATE T_EXPERT_INFORMATION SET EI_NAME = ?, EI_GENDER = ?, EI_MAILBOX = ?, EI_TELEPHONE = ?, EI_USER_NAME = ?, EI_EMPLOYMENT_DATE = ?, EI_DEPARTMENT = ?, EI_GROUP = ?, EI_POSITION = ?, EI_SCOPE_BUSINESS = ?, EI_STATE = ?, EI_SPECIALIZES_FIELDS = ?, EI_EXPERT_INTRODUCTION = ?, EI_ORGANIZATIONAL_CODE = ?, EI_RECORD_TIME = ?, EI_UPDATE_TIME = ?, EI_PHOTO = ?, EI_GROUP_ID = ?, EI_DEPARTMENT_ID = ?, EI_USER_ID = ?, EI_SATISFACTION_SCORE = ?, EI_LEVEL = ?, EI_DISABLED = ?, EI_REGION_CODE = ?, EI_SORT = ? WHERE EI_ID = ?";
        int result=0;
        try {
            result = jdbcTemplate.update(sql, entity.getName(), entity.getGender(), entity.getMailbox(), entity.getTelephone(), entity.getUserName(), entity.getEmploymentDate(), entity.getDepartment(), entity.getGroup(), entity.getPosition(), entity.getScopeBusiness(), entity.getState(), entity.getSpecializesFields(), entity.getExpertIntroduction(), entity.getOrganizationalCode(), entity.getRecordTime(), entity.getUpdateTime(), entity.getPhoto(), entity.getGroupId(), entity.getDepartmentId(), entity.getUserId(), entity.getSatisfactionScore(), entity.getLevel(), entity.getDisabled(), entity.getRegionCode(), entity.getSort(), entity.getId());
        } catch (Exception e) {
            LogHelper.info(e.getMessage());
            //throw new ServiceException("更新 专家信息表 数据 失败。");
        }
        return result >= 0;
    }

    /**
     * 批量新增
     */
    public int[] batchInsert(List<ExpertInformation> list) {
        String sql = "INSERT INTO T_EXPERT_INFORMATION(EI_ID, EI_NAME, EI_GENDER, EI_MAILBOX, EI_TELEPHONE, EI_USER_NAME, EI_EMPLOYMENT_DATE, EI_DEPARTMENT, EI_GROUP, EI_POSITION, EI_SCOPE_BUSINESS, EI_STATE, EI_SPECIALIZES_FIELDS, EI_EXPERT_INTRODUCTION, EI_ORGANIZATIONAL_CODE, EI_RECORD_TIME, EI_UPDATE_TIME, EI_PHOTO, EI_GROUP_ID, EI_DEPARTMENT_ID, EI_USER_ID, EI_SATISFACTION_SCORE, EI_LEVEL, EI_DISABLED, EI_REGION_CODE, EI_SORT) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        int[] result = jdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter() {
            @Override
            public void setValues(PreparedStatement ps, int i) throws SQLException {
                int j = 0;
                ExpertInformation item = list.get(i);
                ps.setObject(++j, item.getId());
                ps.setString(++j, item.getName());
                ps.setString(++j, item.getGender());
                ps.setString(++j, item.getMailbox());
                ps.setString(++j, item.getTelephone());
                ps.setString(++j, item.getUserName());
                ps.setTimestamp(++j, item.getEmploymentDate() != null ? new Timestamp(item.getEmploymentDate().getTime()) : null);
                ps.setString(++j, item.getDepartment());
                ps.setString(++j, item.getGroup());
                ps.setString(++j, item.getPosition());
                ps.setString(++j, item.getScopeBusiness());
                ps.setString(++j, item.getState());
                ps.setString(++j, item.getSpecializesFields());
                ps.setString(++j, item.getExpertIntroduction());
                ps.setString(++j, item.getOrganizationalCode());
                ps.setTimestamp(++j, item.getRecordTime() != null ? new Timestamp(item.getRecordTime().getTime()) : null);
                ps.setTimestamp(++j, item.getUpdateTime() != null ? new Timestamp(item.getUpdateTime().getTime()) : null);
                ps.setString(++j, item.getPhoto());
                ps.setObject(++j, item.getGroupId());
                ps.setObject(++j, item.getDepartmentId());
                ps.setObject(++j, item.getUserId());
                ps.setBigDecimal(++j, item.getSatisfactionScore());
                ps.setString(++j, item.getLevel());
                ps.setString(++j, item.getDisabled());
                ps.setString(++j, item.getRegionCode());
                ps.setObject(++j, item.getSort());
            }

            @Override
            public int getBatchSize() {
                return list.size();
            }
        });
        return result;
    }

    /**
     * 批量更新
     */
    public int[] batchUpdate(List<ExpertInformation> list) {
        String sql = "UPDATE T_EXPERT_INFORMATION SET EI_NAME = ?, EI_GENDER = ?, EI_MAILBOX = ?, EI_TELEPHONE = ?, EI_USER_NAME = ?, EI_EMPLOYMENT_DATE = ?, EI_DEPARTMENT = ?, EI_GROUP = ?, EI_POSITION = ?, EI_SCOPE_BUSINESS = ?, EI_STATE = ?, EI_SPECIALIZES_FIELDS = ?, EI_EXPERT_INTRODUCTION = ?, EI_ORGANIZATIONAL_CODE = ?, EI_RECORD_TIME = ?, EI_UPDATE_TIME = ?, EI_PHOTO = ?, EI_GROUP_ID = ?, EI_DEPARTMENT_ID = ?, EI_USER_ID = ?, EI_SATISFACTION_SCORE = ?, EI_LEVEL = ?, EI_DISABLED = ?, EI_REGION_CODE = ?, EI_SORT = ? WHERE EI_ID = ? ";
        int[] result = jdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter() {
            @Override
            public void setValues(PreparedStatement ps, int i) throws SQLException {
                int j = 0;
                ExpertInformation item = list.get(i);
                ps.setString(++j, item.getName());
                ps.setString(++j, item.getGender());
                ps.setString(++j, item.getMailbox());
                ps.setString(++j, item.getTelephone());
                ps.setString(++j, item.getUserName());
                ps.setTimestamp(++j, item.getEmploymentDate() != null ? new Timestamp(item.getEmploymentDate().getTime()) : null);
                ps.setString(++j, item.getDepartment());
                ps.setString(++j, item.getGroup());
                ps.setString(++j, item.getPosition());
                ps.setString(++j, item.getScopeBusiness());
                ps.setString(++j, item.getState());
                ps.setString(++j, item.getSpecializesFields());
                ps.setString(++j, item.getExpertIntroduction());
                ps.setString(++j, item.getOrganizationalCode());
                ps.setTimestamp(++j, item.getRecordTime() != null ? new Timestamp(item.getRecordTime().getTime()) : null);
                ps.setTimestamp(++j, item.getUpdateTime() != null ? new Timestamp(item.getUpdateTime().getTime()) : null);
                ps.setString(++j, item.getPhoto());
                ps.setObject(++j, item.getGroupId());
                ps.setObject(++j, item.getDepartmentId());
                ps.setObject(++j, item.getUserId());
                ps.setBigDecimal(++j, item.getSatisfactionScore());
                ps.setString(++j, item.getLevel());
                ps.setString(++j, item.getDisabled());
                ps.setString(++j, item.getRegionCode());
                ps.setObject(++j, item.getSort());
                ps.setObject(++j, item.getId());
            }

            @Override
            public int getBatchSize() {
                return list.size();
            }
        });
        return result;
    }

    /**
     * 删除
     */
    @Override
    public boolean delete(String id) {
        String sql = "DELETE FROM T_EXPERT_INFORMATION WHERE EI_ID = ?";
        int result=0;
        try {
            result = jdbcTemplate.update(sql, id);
        } catch (Exception e) {
            LogHelper.info(e.getMessage());
           // throw new ServiceException("删除 专家信息表 数据 失败。");
        }
        return result > 0;
    }

    /**
     * 根据Id查询
     */
    @Override
    public ExpertInformation selectById(String id) {
        String sql = "SELECT * FROM T_EXPERT_INFORMATION WHERE EI_ID = ? ";
        try {
            return jdbcTemplate.queryForObject(sql, new ExpertInformationRowMapper(), id);
        } catch (Exception e) {
            LogHelper.info(e.getMessage());
            return null;
        }
    }

    /**
     * 根据查询条件查询单个对象
     */
    @Override
    public ExpertInformation selectOneByCriteria(ExpertInformationCriteria criteria) {
        StringBuffer buffer = new StringBuffer("SELECT * FROM T_EXPERT_INFORMATION ");
        List<Object> list = OracleUtils.combinationSql(buffer, createCriteriaSql(criteria), 1, 1);
        try {
            return jdbcTemplate.queryForObject(buffer.toString(), list.toArray(), new ExpertInformationRowMapper());
        } catch (Exception e) {
            LogHelper.info(e.getMessage());
            return null;
        }
    }

    /**
     * 根据查询条件查询对象集合
     */
    @Override
    public List<ExpertInformation> selectByCriteria(ExpertInformationCriteria criteria) {
        StringBuffer buffer = new StringBuffer("SELECT * FROM T_EXPERT_INFORMATION ");
        List<Object> list = OracleUtils.combinationSql(buffer, createCriteriaSql(criteria));
        try {
            return jdbcTemplate.query(buffer.toString(), list.toArray(), new ExpertInformationRowMapper());
        } catch (Exception e) {
            LogHelper.info(e.getMessage());
            return null;
        }
    }

    /**
     * 根据查询条件分页查询对象结合
     */
    @Override
    public List<ExpertInformation> selectCriteriaByPage(ExpertInformationCriteria criteria, int pageNum, int pageSize) {
        StringBuffer buffer = new StringBuffer("SELECT * FROM T_EXPERT_INFORMATION ");
        List<Object> list = OracleUtils.combinationSql(buffer, createCriteriaSql(criteria), pageNum, pageSize);
        try {
            return jdbcTemplate.query(buffer.toString(), list.toArray(), new ExpertInformationRowMapper());
        } catch (Exception e) {
            LogHelper.info(e.getMessage());
            return null;
        }
    }

    /**
     * 根据查询条件分页查询对象结合
     */
    @Override
    public List<Map<String,Object>> selectExpertByPage(ExpertInformationCriteria criteria, int pageNum, int pageSize) {
        StringBuffer buffer = new StringBuffer("SELECT EI_NAME 姓名, ( case  when EI_GENDER ='1' then\n" +
                "                   '男'\n" +
                "                  else\n" +
                "                   '女'\n" +
                "                end) 专家性别,\n" +
                "EI_MAILBOX 专家邮箱,EI_TELEPHONE 专家电话,EI_DEPARTMENT 专家部门,EI_GROUP 专家科室,\n" +
                "EI_POSITION 职位,EI_SCOPE_BUSINESS 业务范围,EI_SPECIALIZES_FIELDS 擅长领域,\n" +
                "EI_EXPERT_INTRODUCTION 专家简介,region_name 所属地市 \n" +
                " FROM T_EXPERT_INFORMATION left join (select ed_region_code,region_name from (\n" +
                "select ( case  when ed_region_code =1 then\n" +
                "                   '省本部'\n" +
                "                  else\n" +
                "                   ed_dep_org_name\n" +
                "                end) region_name,ed_region_code  from T_expert_dep\n" +
                ")group by ed_region_code,region_name) a on a.ed_region_code=EI_REGION_CODE ");
        List<Object> list = OracleUtils.combinationSql(buffer, createCriteriaSql(criteria), pageNum, pageSize,"EI_ID");
        try {
            return jdbcTemplate.queryForList(buffer.toString(), list.toArray());
        } catch (Exception e) {
            LogHelper.info(e.getMessage());
            return null;
        }
    }


    /**
     * 根据查询条件分页查询对象结合
     */
    @Override
    public List<Map<String,Object>> selectExpertOutByPage(ExpertInformationCriteria criteria, int pageNum, int pageSize) {
        StringBuffer buffer = new StringBuffer("select eei_id 专家id,\n" +
                "eei_name 专家姓名,\n" +
                "eei_nation 专家民族,\n" +
                "eei_level 专家职称,\n" +
                "eei_political_outlook 政治面貌,\n" +
                "eei_education 学历,\n" +
                "eei_academic_degree 学位,\n" +
                "eei_graduation_school 毕业院校,\n" +
                "eei_major 所学专业,\n" +
                "eei_graduation_time 毕业时间,\n" +
                "eei_work_unit 工作单位,\n" +
                "eei_post 职务,\n" +
                "eei_title 职称高等级证书,\n" +
                "eei_work_profession 从事专业,\n" +
                "eei_professional_years 专业年限,\n" +
                "eei_id_number 身份证号,\n" +
                "eei_declaration_major 申报专业,\n" +
                "eei_postal_address 通讯地址,\n" +
                "eei_mailbox 专家邮箱,\n" +
                "eei_telephone 专家电话,\n" +
                "eei_work_experience 工作履历,\n" +
                "eei_main_academic 主要学术或管理成就,\n" +
                "eei_opinions 推荐单位意见,\n" +
                "eei_recommended_units 推荐单位,\n" +
                "eei_expert_unit_price 专家单价,\n" +
                "eei_coverage_area 服务覆盖区域,\n" +
                "eei_grade 专家等级,\n" +
                "eei_achieve_professional 专业水平,MERGED_NAMES 支撑能力 from T_EXTERNAL_EXPERT_INFO left join (\n" +
                "select ec_eei_id, LISTAGG(nameCl, ',') WITHIN GROUP (ORDER BY nameCl) AS merged_names from（\n" +
                "select ec_eei_id,eei_one_classification ||'-'|| eei_two_classification \n" +
                "||'-'|| eei_three_classification ||'-'|| eei_four_classification  nameCl\n" +
                "from T_EXPERT_CLASSIFICATION）\n" +
                "group by ec_eei_id) on eei_id=ec_eei_id");
        List<Object> list = OracleUtils.combinationSql(buffer, createCriteriaOutSql(criteria), pageNum, pageSize,"eei_id");
        try {
            return jdbcTemplate.queryForList(buffer.toString(), list.toArray());
        } catch (Exception e) {
            LogHelper.info(e.getMessage());
            return null;
        }
    }

    /**
     * 根据条件查询对象总记录数
     */
    @Override
    public Integer selectCountByCriteria(ExpertInformationCriteria criteria) {
        StringBuffer buffer = new StringBuffer("SELECT COUNT(*) FROM T_EXPERT_INFORMATION ");
        List<Object> list = OracleUtils.combinationSql(buffer, createCriteriaSql(criteria));
        int count = jdbcTemplate.queryForObject(buffer.toString(), list.toArray(), int.class);
        return count;
    }

    /**
     * RowMapper
     */
    private class ExpertInformationRowMapper implements RowMapper<ExpertInformation> {
        @Override
        public ExpertInformation mapRow(ResultSet rs, int i) throws SQLException {
            return new ExpertInformation(
                    rs.getObject("EI_ID") != null ? rs.getInt("EI_ID") : null,
                    rs.getString("EI_NAME"),
                    rs.getString("EI_GENDER"),
                    rs.getString("EI_MAILBOX"),
                    rs.getString("EI_TELEPHONE"),
                    rs.getString("EI_USER_NAME"),
                    rs.getTimestamp("EI_EMPLOYMENT_DATE"),
                    rs.getString("EI_DEPARTMENT"),
                    rs.getString("EI_GROUP"),
                    rs.getString("EI_POSITION"),
                    rs.getString("EI_SCOPE_BUSINESS"),
                    rs.getString("EI_STATE"),
                    rs.getString("EI_SPECIALIZES_FIELDS"),
                    rs.getString("EI_EXPERT_INTRODUCTION"),
                    rs.getString("EI_ORGANIZATIONAL_CODE"),
                    rs.getTimestamp("EI_RECORD_TIME"),
                    rs.getTimestamp("EI_UPDATE_TIME"),
                    rs.getString("EI_PHOTO"),
                    rs.getObject("EI_GROUP_ID") != null ? rs.getLong("EI_GROUP_ID") : null,
                    rs.getObject("EI_DEPARTMENT_ID") != null ? rs.getLong("EI_DEPARTMENT_ID") : null,
                    rs.getObject("EI_USER_ID") != null ? rs.getLong("EI_USER_ID") : null,
                    rs.getBigDecimal("EI_SATISFACTION_SCORE"),
                    rs.getString("EI_LEVEL"),
                    rs.getString("EI_DISABLED"),
                    rs.getString("EI_REGION_CODE"),
                    rs.getObject("EI_SORT") != null ? rs.getInt("EI_SORT") : null
            );
        }
    }

    /**
     * 创建查询条件
     */
    private Map<String, Object> createCriteriaSql(ExpertInformationCriteria criteria) {
        Map<String, Object> andMap = new LinkedHashMap<>();
        if (criteria == null)
            return andMap;
        //if (criteria.byId())
        //    andMap.put(criteria.getId() == null ? " T_Id IS NULL " : " T_Id = ? ", criteria.getId());

        //专家姓名
        if (criteria.byName())
            andMap.put(criteria.getName() == null ? " EI_NAME IS NULL " : " EI_NAME = ? ", criteria.getName());
        //专家姓名（LIKE）
        if (criteria.byNameContain())
            andMap.put(" EI_NAME LIKE ? ", "%" + criteria.getNameContain() + "%");
        //专家性别
        if (criteria.byGender())
            andMap.put(criteria.getGender() == null ? " EI_GENDER IS NULL " : " EI_GENDER = ? ", criteria.getGender());
        //专家性别（LIKE）
        if (criteria.byGenderContain())
            andMap.put(" EI_GENDER LIKE ? ", "%" + criteria.getGenderContain() + "%");
        //专家邮箱
        if (criteria.byMailbox())
            andMap.put(criteria.getMailbox() == null ? " EI_MAILBOX IS NULL " : " EI_MAILBOX = ? ", criteria.getMailbox());
        //专家邮箱（LIKE）
        if (criteria.byMailboxContain())
            andMap.put(" EI_MAILBOX LIKE ? ", "%" + criteria.getMailboxContain() + "%");
        //专家电话
        if (criteria.byTelephone())
            andMap.put(criteria.getTelephone() == null ? " EI_TELEPHONE IS NULL " : " EI_TELEPHONE = ? ", criteria.getTelephone());
        //专家电话（LIKE）
        if (criteria.byTelephoneContain())
            andMap.put(" EI_TELEPHONE LIKE ? ", "%" + criteria.getTelephoneContain() + "%");
        //专家OA用户名
        if (criteria.byUserName())
            andMap.put(criteria.getUserName() == null ? " EI_USER_NAME IS NULL " : " EI_USER_NAME = ? ", criteria.getUserName());
        //专家OA用户名（LIKE）
        if (criteria.byUserNameContain())
            andMap.put(" EI_USER_NAME LIKE ? ", "%" + criteria.getUserNameContain() + "%");
        //入职时间
        if (criteria.byEmploymentDate())
            andMap.put(criteria.getEmploymentDate() == null ? " EI_EMPLOYMENT_DATE IS NULL " : " EI_EMPLOYMENT_DATE = ? ", criteria.getEmploymentDate());
        //专家部门
        if (criteria.byDepartment())
            andMap.put(criteria.getDepartment() == null ? " EI_DEPARTMENT IS NULL " : " EI_DEPARTMENT = ? ", criteria.getDepartment());
        //专家部门（LIKE）
        if (criteria.byDepartmentContain())
            andMap.put(" EI_DEPARTMENT LIKE ? ", "%" + criteria.getDepartmentContain() + "%");
        //专家科室
        if (criteria.byGroup())
            andMap.put(criteria.getGroup() == null ? " EI_GROUP IS NULL " : " EI_GROUP = ? ", criteria.getGroup());
        //专家科室（LIKE）
        if (criteria.byGroupContain())
            andMap.put(" EI_GROUP LIKE ? ", "%" + criteria.getGroupContain() + "%");
        //职位
        if (criteria.byPosition())
            andMap.put(criteria.getPosition() == null ? " EI_POSITION IS NULL " : " EI_POSITION = ? ", criteria.getPosition());
        //职位（LIKE）
        if (criteria.byPositionContain())
            andMap.put(" EI_POSITION LIKE ? ", "%" + criteria.getPositionContain() + "%");
        //业务范围
        if (criteria.byScopeBusiness())
            andMap.put(criteria.getScopeBusiness() == null ? " EI_SCOPE_BUSINESS IS NULL " : " EI_SCOPE_BUSINESS = ? ", criteria.getScopeBusiness());
        //业务范围（LIKE）
        if (criteria.byScopeBusinessContain())
            andMap.put(" EI_SCOPE_BUSINESS LIKE ? ", "%" + criteria.getScopeBusinessContain() + "%");
        //调用状态
        if (criteria.byState())
            andMap.put(criteria.getState() == null ? " EI_STATE IS NULL " : " EI_STATE = ? ", criteria.getState());
        //调用状态（LIKE）
        if (criteria.byStateContain())
            andMap.put(" EI_STATE LIKE ? ", "%" + criteria.getStateContain() + "%");
        //擅长领域
        if (criteria.bySpecializesFields())
            andMap.put(criteria.getSpecializesFields() == null ? " EI_SPECIALIZES_FIELDS IS NULL " : " EI_SPECIALIZES_FIELDS = ? ", criteria.getSpecializesFields());
        //擅长领域（LIKE）
        if (criteria.bySpecializesFieldsContain())
            andMap.put(" EI_SPECIALIZES_FIELDS LIKE ? ", "%" + criteria.getSpecializesFieldsContain() + "%");
        //专家简介
        if (criteria.byExpertIntroduction())
            andMap.put(criteria.getExpertIntroduction() == null ? " EI_EXPERT_INTRODUCTION IS NULL " : " EI_EXPERT_INTRODUCTION = ? ", criteria.getExpertIntroduction());
        //专家简介（LIKE）
        if (criteria.byExpertIntroductionContain())
            andMap.put(" EI_EXPERT_INTRODUCTION||EI_SPECIALIZES_FIELDS LIKE ? ", "%" + criteria.getExpertIntroductionContain() + "%");
        //所属OA组织编码
        if (criteria.byOrganizationalCode())
            andMap.put(criteria.getOrganizationalCode() == null ? " EI_ORGANIZATIONAL_CODE IS NULL " : " EI_ORGANIZATIONAL_CODE = ? ", criteria.getOrganizationalCode());
        //所属OA组织编码（LIKE）
        if (criteria.byOrganizationalCodeContain())
            andMap.put(" EI_ORGANIZATIONAL_CODE LIKE ? ", "%" + criteria.getOrganizationalCodeContain() + "%");
        //专家职称
        if (criteria.byLevel())
            andMap.put(criteria.getLevel() == null ? " EI_LEVEL IS NULL " : " EI_LEVEL = ? ", criteria.getLevel());
        //专家职称（LIKE）
        if (criteria.byLevelContain())
            andMap.put(" EI_LEVEL LIKE ? ", "%" + criteria.getLevelContain() + "%");
        //所属地市
        if (criteria.byRegionCode())
            andMap.put(criteria.getRegionCode() == null ? " EI_REGION_CODE IS NULL " : " EI_REGION_CODE = ? ", criteria.getRegionCode());
        //所属地市（LIKE）
        if (criteria.byRegionCodeContain())
            andMap.put(" EI_REGION_CODE LIKE ? ", "%" + criteria.getRegionCodeContain() + "%");
        //所属地市（LIKE）
        if (criteria.byRegionNameContain())
            andMap.put(" region_name LIKE ? ", "%" + criteria.getRegionNameContain() + "%");
        return andMap;
    }

    /**
     * 创建查询条件
     */
    private Map<String, Object> createCriteriaOutSql(ExpertInformationCriteria criteria) {
        Map<String, Object> andMap = new LinkedHashMap<>();
        if (criteria == null)
            return andMap;
        //if (criteria.byId())
        //    andMap.put(criteria.getId() == null ? " T_Id IS NULL " : " T_Id = ? ", criteria.getId());

        //专家姓名
        if (criteria.byName())
            andMap.put(criteria.getName() == null ? " EEI_NAME  IS NULL " : " EEI_NAME  = ? ", criteria.getName());
        //专家姓名（LIKE）
        if (criteria.byNameContain())
            andMap.put(" EEI_NAME  LIKE ? ", "%" + criteria.getNameContain() + "%");
        //专家邮箱
        if (criteria.byMailbox())
            andMap.put(criteria.getMailbox() == null ? " EEI_MAILBOX IS NULL " : " EEI_MAILBOX = ? ", criteria.getMailbox());
        //专家邮箱（LIKE）
        if (criteria.byMailboxContain())
            andMap.put(" EEI_MAILBOX LIKE ? ", "%" + criteria.getMailboxContain() + "%");
        //专家电话
        if (criteria.byTelephone())
            andMap.put(criteria.getTelephone() == null ? " EEI_TELEPHONE IS NULL " : " EEI_TELEPHONE = ? ", criteria.getTelephone());
        //专家电话（LIKE）
        if (criteria.byTelephoneContain())
            andMap.put(" EEI_TELEPHONE LIKE ? ", "%" + criteria.getTelephoneContain() + "%");
        //专家部门
        if (criteria.byDepartment())
            andMap.put(criteria.getDepartment() == null ? " EEI_WORK_UNIT IS NULL " : " EEI_WORK_UNIT = ? ", criteria.getDepartment());

        //专家部门（LIKE）
        if (criteria.byDepartmentContain())
            andMap.put(" EEI_WORK_UNIT LIKE ? ", "%" + criteria.getDepartmentContain() + "%");
        //专家职称
        if (criteria.byLevel())
            andMap.put(criteria.getLevel() == null ? " EEI_LEVEL IS NULL " : " EEI_LEVEL = ? ", criteria.getLevel());
        //专家职称（LIKE）
        if (criteria.byLevelContain())
            andMap.put(" EEI_LEVEL LIKE ? ", "%" + criteria.getLevelContain() + "%");
          //专家简介（LIKE）
        if (criteria.byExpertIntroductionContain())
            andMap.put(" EEI_MAIN_ACADEMIC||EEI_ACHIEVE_PROFESSIONAL||MERGED_NAMES LIKE ? ", "%" + criteria.getExpertIntroductionContain() + "%");

        return andMap;
    }


}
