package com.infoepoch.pms.dispatchassistant.domain.system.dict;

import java.util.List;

public interface IDictDataRepository {

    /**
     * 根据字典类型查询字典值列表
     *
     * @param dictType
     * @return
     */
    List<SystemDictData> selectByDictType(String dictType);

    /**
     * 根据ID查询
     *
     * @param id
     * @return
     */
    SystemDictData selectById(String id);

    /**
     * 条件查询列表数据
     *
     * @param criteria
     * @return
     */
    List<SystemDictData> selectByCriteria(SystemDictCriteria criteria);

    /**
     * 条件查询列表数量
     *
     * @param criteria
     * @return
     */
    int selectByCriteriaCount(SystemDictCriteria criteria);

    /**
     * 插入
     *
     * @param dictData
     */
    void insert(SystemDictData dictData);

    /**
     * 更新
     *
     * @param dictData
     */
    void update(SystemDictData dictData);

    /**
     * 批量替换
     *
     * @param dictDataList
     */
    void batchInsert(List<SystemDictData> dictDataList);

    /**
     * 批量更新
     *
     * @param dictDataList
     */
    void batchUpdate(List<SystemDictData> dictDataList);

    /**
     * 根据ID软删除
     *
     * @param id
     */
    void softDeleteById(String id);

    /**
     * 根据ID删除
     *
     * @param id
     */
    void deleteById(String id);

    /**
     * 根据字典类型软删除
     *
     * @param dictType
     */
    void softDeleteByDictType(String dictType);

    /**
     * 根据字典类型删除
     *
     * @param dictType
     */
    void deleteByDictType(String dictType);

}
