package com.infoepoch.pms.dispatchassistant.domain.langchain.record.conversation;


import java.util.List;

public interface IConversationRepository {

    /**
     * 插入
     *
     * @param entity
     */
    void insert(Conversation entity);

    /**
     * 批量插入
     *
     * @param list
     */
    void batchInsert(List<Conversation> list);

    /**
     * 更新
     *
     * @param entity
     */
    void update(Conversation entity);

    /**
     * 批量更新
     *
     * @param list
     */
    void batchUpdate(List<Conversation> list);

    // region 查询

    /**
     * 根据ID查询
     *
     * @param id
     * @return
     */
    Conversation selectById(String id);

    /**
     * 根据条件查询列表
     *
     * @param criteria
     * @return
     */
    List<Conversation> selectByCriteria(ConversationCriteria criteria);

    /**
     * 根据条件分页查询列表
     *
     * @param criteria
     * @param pageIndex
     * @param pageSize
     * @return
     */
    List<Conversation> selectByCriteriaPage(ConversationCriteria criteria, int pageIndex, int pageSize);

    /**
     * 根据条件查询列表总数量
     *
     * @param criteria
     * @return
     */
    int selectByCriteriaCount(ConversationCriteria criteria);

    // endregion 查询

}
