package com.infoepoch.pms.dispatchassistant.domain.langchain.chat.agentChat;



import com.infoepoch.pms.dispatchassistant.common.exception.ValidationException;
import com.infoepoch.pms.dispatchassistant.domain.langchain.chat.History;
import io.micrometer.core.instrument.util.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AgentChatRequest {

    /**
     * 添加历史记录
     *
     * @param role
     * @param content
     */
    public void addHistory(String role, String content) {
        if (StringUtils.isBlank(role))
            throw new ValidationException("角色不可为空");
        if (StringUtils.isBlank(content))
            throw new ValidationException("内容不可为空");
        if (this.history == null)
            this.history = new ArrayList<>();
        History history = new History(
                role,
                content
        );
        this.history.add(history);
    }

    /**
     * 校验
     */
    public void verify() {
        // 查询语句不可为空
        if (this.query == null || this.query.isEmpty())
            throw new ValidationException("查询语句不可为空");
        // 历史记录如果为null则置为空列表
        if (this.history == null) {
            this.history = new ArrayList<>();
        }
        // 流式输出如果为null则置为false
        if (this.stream == null)
            this.stream = false;
        //
        if (this.modelName == null || this.modelName.isEmpty())
            throw new ValidationException("模型名称不可为空");
        //
        if (this.temperature == null)
            throw new ValidationException("temperature不可为空");
        //
        if (this.maxTokens == null)
            throw new ValidationException("最大字数不可为空");
        //
        if (this.promptName == null || this.promptName.isEmpty())
            throw new ValidationException("提示词名称不可为空");
    }

    /**
     * 转换为入参MAP
     *
     * @return
     */
    public Map<String, Object> toMap() {
        this.verify();
        Map<String, Object> map = new HashMap<>();
        map.put("query", this.query);
        map.put("history", this.history);
        map.put("stream", this.stream);
        map.put("model_name", this.modelName);
        map.put("temperature", this.temperature);
        map.put("max_tokens", this.maxTokens);
        map.put("prompt_name", this.promptName);
        return map;
    }

    public AgentChatRequest() {
    }

    /**
     * 新增
     *
     * @param query
     * @param stream
     * @param modelName
     * @param temperature
     * @param maxTokens
     * @param promptName
     */
    public AgentChatRequest(String query, Boolean stream, String modelName, BigDecimal temperature, Integer maxTokens, String promptName) {
        this.query = query;
        this.stream = stream;
        this.modelName = modelName;
        this.temperature = temperature;
        this.maxTokens = maxTokens;
        this.promptName = promptName;
    }

    /**
     * 查询语句
     */
    private String query;
    /**
     * 历史记录
     */
    private List<History> history;
    /**
     *
     */
    private Boolean stream;
    /**
     * 模型名称
     */
    private String modelName;
    /**
     *
     */
    private BigDecimal temperature;
    /**
     * 最大字数
     */
    private Integer maxTokens;
    /**
     * 提示词名称
     */
    private String promptName;

}
