package com.infoepoch.pms.dispatchassistant.domain.basic.user;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 用户业务处理（新）
 *
 * @Date 2024-06-27
 */
@Service
public class UserQueryService {

    @Autowired
    private IUserRepository userRepository;
    @Autowired
    private IUserQueryRepository userQueryRepository;

    /**
     * 用户弹窗列表
     *
     * @param userCriteria
     * @return
     */
    public List<User> popupList(UserCriteria userCriteria) {
        List<User> userList;
        if (userCriteria.byPage()) {
            userList = userQueryRepository.selectByCriteriaByPage(userCriteria, userCriteria.getPageIndex(), userCriteria.getPageSize());
        } else {
            userList = userQueryRepository.selectByCriteria(userCriteria);
        }
        return userList;
    }

    /**
     * 用户弹窗列表数量
     *
     * @param userCriteria
     * @return
     */
    public int popupListCount(UserCriteria userCriteria) {
        return userQueryRepository.selectCountByCriteria(userCriteria);
    }

    /**
     * @param userCriteria
     * @return
     */
    public List<User> list(UserCriteria userCriteria) {
        List<User> userList;
        if (userCriteria.byPage()) {
            userList = userRepository.selectByCriteriaPage(userCriteria, userCriteria.getPageIndex(), userCriteria.getPageSize());
        } else {
            userList = userRepository.selectByCriteria(userCriteria);
        }
        return userList;
    }



    /**
     * 用户弹窗列表(省公司)
     *
     * @param userCriteria
     * @return
     */
    public List<User> provincePopupList(UserCriteria userCriteria) {
        List<User> userList;
        if (userCriteria.byPage()) {
            userList = userQueryRepository.selectProvinceByCriteriaByPage(userCriteria, userCriteria.getPageIndex(), userCriteria.getPageSize());
        } else {
            userList = userQueryRepository.selectProvinceByCriteria(userCriteria);
        }
        return userList;
    }


    /**
     * 用户弹窗列表数量(省公司)
     *
     * @param userCriteria
     * @return
     */
    public int provincePopupListCount(UserCriteria userCriteria) {
        return userQueryRepository.selectProvinceCountByCriteria(userCriteria);
    }

}
