package com.infoepoch.pms.dispatchassistant.domain.basic.todo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.infoepoch.pms.dispatchassistant.common.component.AbstractCriteria;
import com.infoepoch.pms.dispatchassistant.common.exception.ValidationException;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 待办查询条件
 */
public class TodoCriteria extends AbstractCriteria {

    /*** and查询Map*/
    public Map<String, Object> andMap = new LinkedHashMap<>();

    // id
    public void setId(Object value) {
        this.andMap.put("Id", value);
    }

    // Ids
    public void setIds(List<String> value) {
        //String[] array = value.(new String[value.size()]);
        this.andMap.put("Ids", value);
    }

    // Action
    public void setAction(Boolean value) {
        this.andMap.put("Action", value);
    }

    // Receiver
    public void setReceiver(String value) {
        this.andMap.put("Receiver", value);
    }

    // DocumentType
    public void setDocumentType(String value) {
        this.andMap.put("DocumentType", value);
    }

    // TitleContain

    public boolean byTitleContain(){return this.andMap.containsKey("TitleContain");}
    private String titleContain;

    public String getTitleContain() {
        if (byTitleContain()){
            return titleContain;
        }
        return null;
    }

    public void setTitleContain(String titleContain) {
        this.titleContain = titleContain;
        this.andMap.put("TitleContain",titleContain);
    }

    // Drafter
    public void setDrafter(String value) {
        this.andMap.put("Drafter", value);
    }

    // DocumentTypeList
    public void setDocumentTypeList(List<String> value) {
        String[] array = value.toArray(new String[value.size()]);
        this.andMap.put("DocumentTypeList", array);
    }

    // DomainId
    public void setDomainId(String value) {
        this.andMap.put("DomainId", value);
    }

    // DeploySid
    public void setDeploySid(String value) {
        this.andMap.put("DeploySid", value);
    }

    // ProcessId
    public void setProcessId(String value) {
        this.andMap.put("ProcessId", value);
    }

    // ActivityIdList
    public void setActivityIdList(List<String> value) {
        String[] array = value.toArray(new String[value.size()]);
        this.andMap.put("ActivityIdList", array);
    }

    // SendFlag
    public void setSendFlag(Boolean value) {
        this.andMap.put("SendFlag", value);
    }

    // ActionFlag
    public void setActionFlag(Boolean value) {
        this.andMap.put("ActionFlag", value);
    }

    // ReceiverName
    public void setReceiverName(String value) {
        this.andMap.put("ReceiverName", value);
    }

    // Stage
    public void setStage(String value) {
        this.andMap.put("Stage", value);
    }

    // ActivityIdNotNull (查询流程代办使用该查询条件)
    public void setActivityIdNotNull() {
        this.andMap.put("ActivityIdNotNull", null);
    }

    // ProcessIdNotNull (查询流程代办使用该查询条件)
    public void setProcessIdNotNull() {
        this.andMap.put("ProcessIdNotNull", null);
    }

    //region 根据待办接收人查询
    public boolean byReceiverId(){return this.andMap.containsKey("ReceiverId");}
    private String receiverId;

    public String getReceiverId() {
        if (byReceiverId()){
            return receiverId;
        }
        return null;
    }

    public void setReceiverId(String receiverId) {
        this.receiverId = receiverId;
        this.andMap.put("ReceiverId",receiverId);
    }
    //endregion

    //region 发送时间开始
    public boolean bySendDateStart(){return this.andMap.containsKey("SendDateStart");}
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date sendDateStart;

    public Date getSendDateStart() {
        if (bySendDateStart()){
            return sendDateStart;
        }
        return null;
    }

    public void setSendDateStart(Date sendDateStart) {
        this.sendDateStart = sendDateStart;
        this.andMap.put("SendDateStart",sendDateStart);
    }
    //endregion

    //region 发送时间结束
    public boolean bySendDateEnd(){return this.andMap.containsKey("SendDateEnd");}
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date sendDateEnd;

    public Date getSendDateEnd() {
        if (bySendDateEnd()){
            return sendDateEnd;
        }
        return null;
    }

    public void setSendDateEnd(Date sendDateEnd) {
        this.sendDateEnd = sendDateEnd;
        this.andMap.put("SendDateEnd",sendDateEnd);
    }
    //endregion

    /**
     * @Description: 校验处理代办必传项
     * @Param: [criteria]
     * @Author: zhangyd
     */
    public static void validationActionTodoCriteria(TodoCriteria criteria) {
        if (!criteria.andMap.containsKey("Id")
                && !criteria.andMap.containsKey("ProcessId")
                && !criteria.andMap.containsKey("ActivityIdList")
                && !criteria.andMap.containsKey("Ids")
                && !criteria.andMap.containsKey("DomainId")
                && !criteria.andMap.containsKey("DocumentType"))
            throw new ValidationException("校验处理代办失败");
    }
}
