package com.infoepoch.pms.dispatchassistant.domain.basic.menu;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author xuyj
 * @description 菜单服务类（区分主菜单、合作单位菜单）
 * @date 2019-11-11 15:49
 */
@Service
public class MenuService {


    @Autowired
    IMenuRepository menuRepository;

    /**
     * 创建菜单
     *
     * @param menu
     */
    public void createMenu(Menu menu) {
        menu = menu.create();
        menuRepository.insert(menu);
    }

    /**
     * 删除菜单
     *
     * @param id
     */
    public void removeMenuById(String id) {
        menuRepository.deleteMenuById(id);
    }

    /**
     * 修改菜单
     *
     * @param menu
     */
    public void modifyMenuById(Menu menu) {
        menuRepository.updateMenuById(menu);
    }

    /**
     * 查询菜单（用与菜单管理）
     *
     * @param isMainMenu true 移动用户菜单,false 合作单位菜单
     * @return
     */
    public List<Menu> query(boolean isMainMenu) {
        return menuRepository.selectAll(isMainMenu ? Menu.TYPE_MENU_MAIN : Menu.TYPE_MENU_COOP);
    }

    /**
     * 取主菜单根
     *
     * @return
     */
    public List<Menu> queryMainMenu(String userId) {
        List<Menu> menus = menuRepository.selectMainMenuByUserId(userId);
        if (CollectionUtils.isEmpty(menus)) {
            menus = menuRepository.selectMainMenuByRoleName("普通员工");
        }
        //取顶级节点（parentId为-1）
        List<Menu> topNode = menus.stream().filter(menu -> menu.getParentId().equals("-1")).collect(Collectors.toList());
        //从源菜单中删除顶级节点
        menus.removeAll(topNode);
        for (Menu menu : topNode) {
            recursiveMenus(menu, menus);
        }
        return topNode;
    }

    /**
     * 查询软件项目管理全流程系统菜单
     *
     * @param userId
     * @return
     */
    public List<Menu> querySupermarketMenu(String userId) {
        List<Menu> menus = menuRepository.selectMainMenuByUserId(userId);
        if (CollectionUtils.isEmpty(menus)) {
            menus = menuRepository.selectMainMenuByRoleName("普通员工");
        }
        Menu topNode = null;
        for (Menu menu : menus) {
            if (menu.getName().equals("软件项目管理全流程系统")) {
                topNode = menu;
                break;
            }
        }
        if (topNode == null) {
            return new ArrayList<>();
        }
        menus.remove(topNode);
        List<Menu> topNodeList = new ArrayList<>();
        for (Menu menu : menus) {
            if (menu.getParentId().equals(topNode.getId()))
                topNodeList.add(menu);
        }
        menus.removeAll(topNodeList);
        for (Menu menu : topNodeList) {
            recursiveMenus(menu, menus);
        }
        return topNodeList;
    }

    /**
     * 查询培训平台菜单地址
     *
     * @param userId
     * @return
     */
    public List<Menu> queryPortalMenu(String userId) {
        List<Menu> menus = menuRepository.selectMainMenuByUserId(userId);
        if (CollectionUtils.isEmpty(menus)) {
            menus = menuRepository.selectMainMenuByRoleName("普通员工");
        }
        Menu topNode = null;
        for (Menu menu : menus) {
            if (menu.getName().equals("培训计划系统")) {
                topNode = menu;
                break;
            }
        }
        if (topNode == null) {
            return new ArrayList<>();
        }
        menus.remove(topNode);
        List<Menu> topNodeList = new ArrayList<>();
        for (Menu menu : menus) {
            if (menu.getParentId().equals(topNode.getId()))
                topNodeList.add(menu);
        }
        menus.removeAll(topNodeList);
        for (Menu menu : topNodeList) {
            recursiveMenus(menu, menus);
        }
        return topNodeList;
    }

    /**
     * 递归寻找父节点的所有children
     *
     * @param topNode
     * @param menus
     */
    private void recursiveMenus(Menu topNode, List<Menu> menus) {
        List<Menu> children = new ArrayList<>();
        Iterator<Menu> iterator = menus.iterator();
        while (iterator.hasNext()) {
            Menu menu = iterator.next();
            if (menu.getParentId().equals(topNode.getId())) {
                children.add(menu);
//                iterator.remove();
                recursiveMenus(menu, menus);
            }
        }
        topNode.setChildren(children);
    }


    /**
     * 取合作单位菜单显示
     *
     * @return
     */
    public List<Menu> queryCoopMenu(String id) {
        List<Menu> menus = menuRepository.selectMainMenuBySaId(id);
        if (CollectionUtils.isEmpty(menus)) {
            menus = menuRepository.selectMainMenuBySaRoleName("常规供应商");
        }
        //取顶级节点（parentId为-1）
        List<Menu> topNode = menus.stream().filter(menu -> menu.getParentId().equals("-1")).collect(Collectors.toList());
        //从源菜单中删除顶级节点
        menus.removeAll(topNode);
        for (Menu menu : topNode) {
            recursiveMenus(menu, menus);
        }
        return topNode;
    }

    /**
     * 根据名称查询菜单
     */
    public List<Menu> getMenuListByName(String name) {
        return menuRepository.selectByName(name);
    }

    /**
     * 根据id 获取菜单
     *
     * @param id
     * @return
     */
    public Menu getMenuById(String id) {
        return menuRepository.selectById(id);
    }

    /**
     * 根据菜单名称集合查询菜单
     */
    public List<Menu> getMenuListByNameList(List<String> nameList) {
        return menuRepository.selectByNameList(nameList);
    }
}
