package com.infoepoch.pms.dispatchassistant.common.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 密码工具类
 * <p>
 * 密码强度要求：
 * 1.不少于8位
 * 2.数字、大小写字母、特殊字符 至少有2种
 */
public class PasswordTool {

    public final static String PASSWORD_REGEX = "^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9])(?=.*?[!@#$%^&*-?]).{8,20}$";

    public final static String VALIDATION_WARN = "请确保数字、大写字母、小写字母、指定特殊符号均至少包含一个，且长度为8-20位。";

    /**
     * 密码校验
     *
     * @param password
     */
    public static boolean validation(String password) {
        Pattern pattern = Pattern.compile(PASSWORD_REGEX);
        Matcher matcher = pattern.matcher(password);
        return matcher.matches();
    }

    /**
     * 密码校验结果转置
     *
     * @param password
     * @return
     */
    public static boolean validationReverse(String password) {
        return !validation(password);
    }

}
