package com.infoepoch.pms.dispatchassistant.common.exception;


import com.infoepoch.pms.dispatchassistant.common.constant.ErrorCodes;

/**
 * 未登录异常
 */
public class NotLoginException extends Exception {

    private int code = ErrorCodes.NOT_LOGIN;

    /**
     * 构造函数
     */
    public NotLoginException() {
        super();
    }

    /**
     * 构造函数
     */
    public NotLoginException(int code) {
        super();
        this.code = code;
    }

    /**
     * 构造函数
     */
    public NotLoginException(String message) {
        super(message);
    }

    /**
     * 构造函数
     */
    public NotLoginException(int code, String message) {
        super(message);
        this.code = code;
    }

    /**
     * 构造函数
     */
    public NotLoginException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * 构造函数
     */
    public NotLoginException(Throwable cause) {
        super(cause);
    }

    public int getCode() {
        return code;
    }
}
