package com.infoepoch.pms.dispatchassistant.common.enums;

import java.util.Collections;
import java.util.List;

/**
 * 枚举树结构
 *
 * @author liudx
 */
public class EnumTree {

    private Integer value;

    private String text;

    private List<EnumTree> children;

    public EnumTree() {
        // 无参构造
    }

    public EnumTree(Integer value, String text) {
        this.value = value;
        this.text = text;
    }

    public EnumTree addChildren(List<EnumTree> children){
        this.children = children;
        return this;
    }

    public Integer getValue() {
        return value;
    }

    public String getText() {
        return text;
    }

    public List<EnumTree> getChildren() {
        return null == children ? Collections.emptyList() : children;
    }

}
