package com.infoepoch.pms.dispatchassistant.common.component;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

/**
 * 用于在应用启动加载时根据配置值实例化SnowFlake
 */
@Component
public class Runner implements ApplicationRunner {

    @Value("${snowflake.datacenter-id:0}")
    long datacenterId;

    @Value("${snowflake.machine-id:0}")
    long machineId;

    @Override
    public void run(ApplicationArguments arguments) {
        //根据配置文件实例SnowFlake
        SnowFlake.init(datacenterId, machineId);
    }
}