//流程引擎调试组件
define(['jquery', 'vue', 'layer'], function ($, Vue, layer) {
    return Vue.component('process-engine-debug', {
        props: {},
        data: function () {
            return {}
        },
        template: '<span>\
            <button type="button" class="btn btn_primary" @click="openDebugPanel"><i class="iconfont icon-debug"></i>调试</button>\
            <!--调试-->\
            <div class="container" id="processEngineDebugPanel" style="display: none; color: #333333; font-weight: normal;">\
                deploySid：{{$parent.deploySid}}<br>\
                actor：{{$parent.actor}}<br>\
                currentActivity:<br>\
                <textarea class="form_control" rows="5" readonly>{{$parent.currentActivity}}</textarea>\
                currentAction:<br>\
                <textarea class="form_control" rows="5" readonly>{{$parent.currentAction}}</textarea>\
                nextActivityId：{{$parent.nextActivityId}}<br>\
                domainId：{{$parent.domainId}}<br>\
                domainData：<br>\
                <textarea class="form_control" rows="5" readonly>{{$parent.domainData}}</textarea>\
                returnToRuntimeActivityId：{{$parent.returnToRuntimeActivityId}}<br>\
                hiddenWhenNoDomain：{{$parent.hiddenWhenNoDomain}}\
            </div>\
        </span>',
        created: function () {
        },
        mounted: function () {
        },
        watch: {},
        computed: {},
        methods: {
            //显示调试信息
            openDebugPanel: function () {
                var that = this;
                layer.open({
                    type: 1,
                    area: '555px',
                    title: '流程引擎组件调试信息',
                    content: $('#processEngineDebugPanel'),
                    btn: ['确定', '加载测试流程数据', '加载空流程数据', '加载页面流程数据'],
                    yes: function (index, layero) {
                        layer.close(index);
                    },
                    btn2: function (index, layero) {
                        var pendingActivities = [{
                            sid: 'TASK1',
                            name: '审批1（1动作1退回）',
                            actions: [{
                                name: '审批1-处理1',
                                nextActivityId: '10',
                                commentLabel: '审批1-处理1-意见',
                                commentRequired: true,
                                additionalControl: 'peac-p1all-user'
                            }],
                            returns: [{
                                activityName: '审批1退回1',
                                activitySid: 'return1',
                                actorName: '张三',
                                returnToRuntimeActivityId: 'r1'
                            }]
                        }, {
                            sid: 'TASK2',
                            name: '审批2（2动作2退回）',
                            actions: [{
                                name: '审批2-处理1',
                                nextActivityId: '21',
                                commentLabel: '审批2-处理1-意见',
                                commentRequired: true,
                                additionalControl: 'peac-p1all-user'
                            }, {
                                name: '审批2-处理2',
                                nextActivityId: '22',
                                commentLabel: '审批2-处理2-意见',
                                commentRequired: true,
                                additionalControl: ''
                            }],
                            returns: [
                                {
                                    activityName: '审批2退回1',
                                    activitySid: 'return1',
                                    actorName: '张三',
                                    returnToRuntimeActivityId: 'r21'
                                },
                                {
                                    activityName: '审批2退回2',
                                    activitySid: 'return2',
                                    actorName: '李四',
                                    returnToRuntimeActivityId: 'r22'
                                }
                            ]
                        }, {
                            sid: 'TASK3',
                            name: '审批3（1动作0退回）',
                            actions: [{
                                name: '审批3-处理1',
                                nextActivityId: '31',
                                commentLabel: '审批3-处理1-意见',
                                commentRequired: true,
                                additionalControl: ''
                            }],
                            returns: []
                        }, {
                            sid: 'TASK4',
                            name: '审批4（无意见）',
                            actions: [{
                                name: '审批4-处理1',
                                nextActivityId: '41',
                                commentLabel: '审批4-处理1-意见',
                                commentRequired: null,
                                additionalControl: ''
                            }],
                            returns: []
                        }];

                        if (confirm('确定要加载流程测试数据吗？仅用于查看显示效果，无法处理和退回。可通过“重新加载页面流程数据”按钮加载原始流程数据。')) {
                            that.$emit('set-debug-data', pendingActivities);
                            return true;
                        }
                        return false;
                    },
                    btn3: function (index, layero) {
                        if (confirm('确定要加载空流程数据吗？仅用于查看显示效果。可通过“重新加载页面流程数据”按钮加载原始流程数据。')) {
                            that.$emit('set-debug-data', []);
                            return true;
                        }
                        return false;
                    },
                    btn4: function (index, layero) {
                        that.$parent.loadProcess();
                        layer.close(index);
                    },
                });
            }
        }
    });
});
