//流程引擎选择单个人员组件，使用树组件

define(['jquery', 'vue', '../../libs/jquery.ztree/fuzzysearch.js', 'jquery-ztree']
    , function ($, Vue, fuzzySearch) {
        return Vue.component('peac-transfer-user', {
            data: function () {
                return {
                    selectedId: '',
                    selectedName: '',
                    treeId: 'tree' + Math.floor(100000000 + Math.random() * 900000000),     //生成随机id
                    searchId: 'search' + Math.floor(100000000 + Math.random() * 900000000),  //生成随机id,
                    region:'',
                    organizationId:'',
                    userId:'',
                    isTransfer:'',
                    domainId:'',
                    permission:'',
                    regionCode:''
                }
            },
            template: '<div>\
                    <div class="peac_column peac_column_tree" style="overflow: hidden;">\
                        <div class="peac_column_title">\
                           <select class="form_control" v-model="isTransfer" @change="selectTransfer()">\
                                    <option value="">请选择是否转办</option>\
                                    <option value="1">是</option>\
                                    <option value="0">否</option>\
                          </select>\
                          </div>\
                          <div class="peac_column_title">\
                        <input type="text" :id="searchId" class="form_control" placeholder="请输入搜索内容" />\
                        </div>\
                        <div class="peac_tree_container">\
                            <ul :id="treeId" class="ztree"></ul>\
                        </div>\
                    </div>\
                    <div class="peac_column peac_column_selected">\
                        <div class="peac_column_title">已选择人员</div>\
                        <div class="peac_selected_container">\
                            <div class="peac_selected_item" v-if="selectedId != \'\'">\
                                <div class="peac_selected_name">{{selectedName}}</div>\
                                <div class="peac_selected_remove" @click="clear">╳</div>\
                            </div>\
                        </div>\
                    </div>\
                </div>',
            created: function () {
            },
            mounted: function () {
                var _that=this;
                var reg = new RegExp('(^|&)' + 'domainId' + '=([^&]*)(&|$)', 'i');
                var r = window.location.search.substr(1).match(reg);
                _that.domainId= decodeURIComponent(r[2]);
                $.ajax({
                    url: currentLoginUser,
                    type: "get",
                    async:false,
                    success: function (data) {
                        _that.region = data.data.regionName;
                        _that.organizationId = data.data.orgCode;
                        _that.userId = data.data.username;
                        _that.regionCode = data.data.regionCode;
                    }
                });
            },
            computed: {},
            methods: {
                clear: function () {
                    this.selectedId = '';
                    this.selectedName = '';
                    var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                    var nodes = treeObj.getCheckedNodes(true);
                    if (nodes.length > 0)
                        treeObj.checkNode(nodes[0], false);
                },
                expand: function () {
                    var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                    treeObj.expandAll(true);
                },
                collapse: function () {
                    var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                    treeObj.expandAll(false);
                },
                search: function () {
                    var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                    treeObj.fuzzySearch(false);
                },
                verifyValue: function () {
                    if (this.isTransfer == '') {
                        alert('请选择是否转办');
                        return false;
                    }
                    if (this.selectedId == '') {
                        alert('请选择处理人。');
                        return false;
                    }
                    return true;
                },
                getValue: function () {
                    //特殊业务
                    $.ajax({
                        url: "../../v1/updateIsTransfer",
                        type: "post",
                        async:false,
                        data:{domainId:this.domainId,isTransfer:this.isTransfer,regionCode:this.regionCode}
                    });
                    return this.selectedId + '::' + this.selectedName;
                },
                selectTransfer:function () {
                    var that=this;
                    var setting = {
                        check: {
                            enable: true,
                            chkStyle: 'radio',
                            radioType: 'all'
                        },
                        view: {showIcon: false},
                        callback: {
                            onClick: function (event, treeId, treeNode) {
                                var zTree = $.fn.zTree.getZTreeObj(treeId);
                                if (treeNode.isParent) {
                                    if (treeNode.open) {
                                        zTree.expandNode(treeNode, false);
                                    } else {
                                        zTree.expandNode(treeNode, true);
                                    }
                                } else {
                                    zTree.checkNode(treeNode, !treeNode.checked, true, true);
                                }
                            },
                            onCheck: function (event, treeId, treeNode) {
                                //console.log(treeNode);
                                //console.log(treeId + ', ' + treeNode.tId + ', ' + treeNode.id + ', ' + treeNode.name + ',' + treeNode.checked);
                                if (treeNode.checked) {
                                    that.selectedId = treeNode.id;
                                    if (treeNode.oldname != undefined)
                                        that.selectedName = treeNode.oldname;
                                    else
                                        that.selectedName = treeNode.name;
                                } else {
                                    that.selectedId = '';
                                    that.selectedName = '';
                                }
                            }
                        }
                    };
                    if (that.isTransfer=='0'){
                        $.ajax({
                            url: "../../v1/getApplyProcessAppRoverMessage",
                            type: "get",
                            data: {'organizationId': this.organizationId, 'userId' : this.domainId,'permission':''},
                            // contentType: "x-www-form-urlencoded",
                            success: function (data) {
                                var zNodes = data.data.data;
                                var zTreeObj = $.fn.zTree.init($('#' + that.treeId), setting, zNodes);    //绑定树
                                fuzzySearch.fuzzySearch(that.treeId, '#' + that.searchId, true, true);
                                //自动展开第一个根节点
                                if(zTreeObj.getNodes().length > 0)
                                    zTreeObj.expandNode(zTreeObj.getNodes()[0], true);
                            }
                        });
                    }
                    else if(that.isTransfer=='1') {
                        $.ajax({
                            url: "../../v1/getApplyProcessAppRoverMessage",
                            type: "get",
                            data: {'organizationId': this.organizationId, 'userId' : that.regionCode,'permission':'地市'},
                            success: function (data) {
                                var zNodes = data.data.data;
                                var zTreeObj = $.fn.zTree.init($('#' + that.treeId), setting, zNodes);    //绑定树
                                fuzzySearch.fuzzySearch(that.treeId, '#' + that.searchId, true, true);
                                //自动展开第一个根节点
                                if(zTreeObj.getNodes().length > 0)
                                    zTreeObj.expandNode(zTreeObj.getNodes()[0], true);
                            }
                        });
                    }else {
                        that.selectedId = '';
                        that.selectedName = '';
                        var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                        var nodes = treeObj.getCheckedNodes(true);
                        if (nodes.length > 0)
                            treeObj.checkNode(nodes[0], false);
                    }
                }
            }
        });
    });
