//流程引擎历史记录组件v2
define(['jquery', 'vue'], function ($, Vue) {
    return Vue.component('process-engine-history-extend-v2', {
        template: '<div class="detail_content process_content">\
                    <van-cell-group v-for="(history, index) in filterHistories" :key="history.id">\
                        <van-cell title="处理环节" :value="history.activityName"></van-cell>\
                        <van-cell title="处理人" :value="history.actorName"></van-cell>\
                        <van-cell title="处理意见" :value="history.comment"></van-cell>\
                        <van-cell title="处理开始时间" :value="history.beginTime"></van-cell>\
                        <van-cell title="处理结束时间" :value="history.finishTime"></van-cell>\
                        <van-cell title="状态" :value="getHistoryState(history)"></van-cell>\
                    </van-cell-group>\
            </div>',
        props: {
            historiesExtend: {
                default: function () {
                    return [];
                }
            }
        },
        data: function () {
            return {
                showSystem: false,
                // showHistory: false
            }
        },
        computed: {
            filterHistories: function () {
                if (this.historiesExtend && this.historiesExtend.length > 0) {
                    if (this.showSystem) {
                        return this.historiesExtend;
                    } else
                        return $.grep(this.historiesExtend, function (item, index) {
                            return item.activityType == 'Task' || (item.batchId == "" && item.activityType == "End");
                        });
                }
                return []

            }
        },
        watch: {},
        created: function () {
            //子组件中需要增加v-if判断以结束递归
        },
        mounted: function () {
        },
        methods: {
            getHistoryState: function (history) {
                if (!history.finished)
                    return '待处理';
                if (history.actionType == 'Return')
                    return '已退回';
                if (history.actionType == 'Deliver')
                    return '已转交';
                return '已处理';
            }
        }
    });
});
