//流程引擎流程表达式选人
define(['jquery', 'vue', 'vant', 'listUtil']
    , function ($, Vue, vant, listUtil) {
        return Vue.component('peac-url-user-picker', {
            data: function () {
                return {
                    actorUrl: '',
                    actorId: '',
                    domainId: '',
                    selectedId: '',
                    selectedName: '',
                    treeId: 'tree' + Math.floor(100000000 + Math.random() * 900000000),     //生成随机id
                    expandPanel: true,
                    ztree: '',
                }
            },
            template: '<div class="select_user">\
                        <div class="select_user_title" @click="expandPanel = !expandPanel">\
                            <span>处理人</span>\
                        </div>\
                        <ul :id="treeId" class="ztree" v-show="expandPanel"></ul>\
                    </div>',
            created: function () {
            },
            mounted: function () {
            },
            computed: {},
            methods: {
                setParams: function (actorUrl, actorId, domainId) {
                    if (actorUrl == undefined)
                        return;
                    this.actorUrl = actorUrl;
                    this.actorId = actorId;
                    this.domainId = domainId;
                    this.bindTree();
                },
                bindTree: function () {
                    var that = this
                    if (this.actorUrl == ''){
                        $.fn.zTree.destroy(this.treeId);
                        return;
                    }

                    var setting = {
                        check: {
                            nocheckInherit: false,
                            enable: true,
                            chkStyle: 'radio',
                            radioType: 'all'
                        },
                        view: {
                            showIcon: false,
                            showLine: false
                        },
                        callback: {
                            beforeClick: function (treeId, treeNode) {
                                if (treeNode.isParent) {
                                    if (treeNode.open) {
                                        that.ztree.expandNode(treeNode, false);
                                    } else {
                                        that.ztree.expandNode(treeNode, true);
                                    }
                                } else {
                                    that.ztree.checkNode(treeNode, !treeNode.checked, true, true);
                                }
                                return false;
                            },
                            onCheck: function (event, treeId, treeNode) {
                                //console.log(treeNode);
                                //console.log(treeId + ', ' + treeNode.tId + ', ' + treeNode.id + ', ' + treeNode.name + ',' + treeNode.checked);
                                if (treeNode.checked) {
                                    that.selectedId = treeNode.id;
                                    if (treeNode.oldname != undefined)
                                        that.selectedName = treeNode.oldname;
                                    else
                                        that.selectedName = treeNode.name;
                                } else {
                                    that.selectedId = '';
                                    that.selectedName = '';
                                }
                            }
                        }
                    };

                    $.ajax({
                        dataType: 'JSON',
                        type: 'GET',
                        url: that.actorUrl,
                        success: function (data) {
                            var zNodes = data.data;
                            that.ztree = $.fn.zTree.init($('#' + that.treeId), setting, zNodes);    //绑定树
                        }
                    });
                    // $.ajax({
                    //     url: '../../asset/libs/process-engine-mobile-v3/json/getCMCCRoleUser.json',
                    //     type: 'get',
                    //     success: function (data) {
                    //         var zNodes = data.data;
                    //         that.ztree = $.fn.zTree.init($('#' + that.treeId), setting, zNodes);    //绑定树
                    //         //自动展开第一个根节点
                    //         // if(that.ztree.getNodes().length > 0)
                    //         //     that.ztree.expandNode(that.ztree.getNodes()[0], true);
                    //     }
                    // });

                },
                clear: function () {
                    this.selectedId = '';
                    this.selectedName = '';
                    var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                    var nodes = treeObj.getCheckedNodes(true);
                    if (nodes.length > 0)
                        treeObj.checkNode(nodes[0], false);
                },
                verifyValue: function () {
                    if (this.selectedId == '' || this.selectedId == null) {
                        vant.Toast("请选择处理人。");
                        return false;
                    }
                    return true;
                },
                getValue: function () {
                    return this.selectedId + '::' + this.selectedName;
                }
            }
        });
    });
