define(['jquery', 'vue', 'vant', 'listUtil'], function ($, Vue, vant, listUtil) {
    return Vue.component('peac-base-users', {
        template: '<div class="select_user">\
                        <div class="select_user_title" @click="expandPanel = !expandPanel">\
                            <span>处理人</span>\
                        </div>\
                        <ul :id="treeId" class="ztree" v-show="expandPanel"></ul>\
                    </div>',
        props: {
            restUrl: {default: ""},
            organizationId: {default: ""}, //当前用户所属组织Id或者指定组织id
            userId: {default: ""}, //当前用户Id
            permission: {default: ""}
        },
        data() {
            return {
                selectedItems: [],
                treeId: 'tree' + Math.floor(100000000 + Math.random() * 900000000),     //生成随机id
                expandPanel: true,
                ztree: '',
            };
        },
        created: function () {
        },
        mounted: function () {
            this.bindTree();
        },
        watch: {
            url: function (newValue, oldValue) {
                this.bindTree();
            },
            organizationId: function (newValue, oldValue) {
                this.bindTree();
            },
            userId: function (newValue, oldValue) {
                this.bindTree();
            },
            permission: function(newValue, oldValue){
                this.bindTree();
            }
        },
        computed: {},
        methods: {
            bindTree: function () {
                var that = this;
                if (this.restUrl == '' || this.organizationId == '') {
                    $.fn.zTree.destroy(this.treeId);
                    return;
                }

                var setting = {
                    check: {
                        enable: true,
                        chkStyle: 'checkbox',
                        radioType: 'all',
                        //chkboxType: {'Y': 'ps', 'N': 'ps'}
                    },
                    view: {showIcon: false,showLine: false},
                    callback: {
                        beforeClick: function (treeId, treeNode) {
                            if (treeNode.isParent) {
                                if (treeNode.open) {
                                    that.ztree.expandNode(treeNode, false);
                                } else {
                                    that.ztree.expandNode(treeNode, true);
                                }
                            } else {
                                that.ztree.checkNode(treeNode, !treeNode.checked, true, true);
                            }
                            return false;
                        },
                        onCheck: function zTreeOnCheck(event, treeId, treeNode) {
                            //console.log(treeNode);
                            //console.log(treeId + ', ' + treeNode.tId + ', ' + treeNode.id + ', ' + treeNode.name + ',' + treeNode.checked);
                            var treeObj = $.fn.zTree.getZTreeObj(treeId);
                            var nodes = treeObj.getCheckedNodes(true);
                            //console.log(nodes);
                            that.selectedItems = $.map(nodes, function (node, index) {
                                if (!node.isParent) {
                                    var name = node.name;
                                    if (node.oldname)
                                        name = node.oldname;
                                    return {id: node.id, name: name};
                                }
                            });
                        }
                    }
                };

                $.ajax({
                    dataType: 'JSON',
                    type: 'GET',
                    url: that.restUrl,
                    data: {organizationId: that.organizationId, userId: that.userId, permission: that.permission, multiple: true},
                    success: function (data) {
                        var zNodes = data.data;
                        that.ztree = $.fn.zTree.init($('#' + that.treeId), setting, zNodes);    //绑定树
                    }
                });
                // $.ajax({
                //     dataType: 'JSON',
                //     type: 'GET',
                //     url: '../../asset/libs/process-engine-mobile-v3/json/getCMCCRoleUser.json',
                //     data: {organizationId: that.organizationId, userId: that.userId, permission: that.permission, multiple: true},
                //     success: function (data) {
                //         var zNodes = data.data;
                //         that.ztree = $.fn.zTree.init($('#' + that.treeId), setting, zNodes);    //绑定树\
                //     }
                // });
            },
            expand: function () {
                var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                treeObj.expandAll(true);
            },
            collapse: function () {
                var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                treeObj.expandAll(false);
            },
            search: function () {
                var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                treeObj.fuzzySearch(false);
            },
            verifyValue: function () {
                if (this.selectedItems.length == 0) {
                    vant.Toast("请选择处理人。");
                    return false;
                }
                return true;
            },
            getValue: function () {
                var items = $.map(this.selectedItems, function (item, index) {
                    return item.id + '::' + item.name;
                });
                return items;
            }
        }
    })
})

