package com.infoepoch.pms.dispatchassistant.infractructure.oa;

import com.infoepoch.pms.dispatchassistant.common.component.SnowFlake;
import com.infoepoch.pms.dispatchassistant.common.utils.LambdaTool;
import com.infoepoch.pms.dispatchassistant.domain.oa.IOaRepository;
import com.infoepoch.pms.dispatchassistant.domain.oa.account.SBMDMMDMPageInquiryOAStandardEmpolyeeInfoSrvOutputItem;
import com.infoepoch.pms.dispatchassistant.domain.oa.organization.IOaOrganizationRepository;
import com.infoepoch.pms.dispatchassistant.domain.oa.organization.OaOrganization;
import com.infoepoch.pms.dispatchassistant.domain.oa.organization.OaOrganizationCriteria;
import com.infoepoch.pms.dispatchassistant.domain.oa.organization.sync.SBMDMMDMPageInquiryOAStandardOrgInfoSrvOutputItem;
import com.infoepoch.pms.dispatchassistant.domain.oa.user.UserPms;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Repository
public class OaRepository implements IOaRepository {

    private final static Logger logger = LoggerFactory.getLogger(OaRepository.class);

    @Autowired
    private UserPmsRepository userPmsRepository;
    @Autowired
    private IOaOrganizationRepository oaOrganizationRepository;

    @Override
    public void batchInsertEmployeeSingle(List<SBMDMMDMPageInquiryOAStandardEmpolyeeInfoSrvOutputItem> itemList) {
        if (!itemList.isEmpty()) {
            List<UserPms> oaUserList = new ArrayList<>();
            for (SBMDMMDMPageInquiryOAStandardEmpolyeeInfoSrvOutputItem item : itemList) {
                userPmsRepository.deleteByEmployeeNumber(item.getEMPLOYEENUMBER());
                UserPms oaUser = transferItemToUserPms(item);
                oaUserList.add(oaUser);
            }
            userPmsRepository.batchInsert(oaUserList);
        }
    }

    private UserPms transferItemToUserPms(SBMDMMDMPageInquiryOAStandardEmpolyeeInfoSrvOutputItem item) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date reference1 = null;
        if (!StringUtils.isEmpty(item.getREFERENCE1())) {
            try {
                reference1 = new java.sql.Timestamp(format.parse(item.getREFERENCE1()).getTime());
            } catch (Exception e) {
                logger.info("【员工编码=" + item.getEMPLOYEENUMBER() + ",reference2=" + item.getREFERENCE2() + "】的reference1转换失败");
            }
        }
        UserPms oaUser = new UserPms(
                SnowFlake.instant().nextId(),
                item.getEMPLOYEENUMBER(),
                item.getFULLNAME(),
                item.getSEX(),
                item.getRETIRESTATUS(),
                item.getEMPLOYEETYPE(),
                item.getMOBILENUMBER(),
                item.getEMAIL(),
                item.getISPRIMARYACCOUNT(),
                item.getHRORGCODE(),
                item.getOAORGCODE(),
                item.getDUTY(),
                item.getDISPLAYORDER(),
                reference1,
                item.getREFERENCE2(),
                item.getREFERENCE3(),
                item.getREFERENCE4(),
                item.getREFERENCE5(),
                item.getREFERENCE6(),
                item.getREFERENCE7(),
                item.getREFERENCE8(),
                item.getREFERENCE9(),
                item.getREFERENCE10(),
                item.getREFERENCE1(),
                item.getREFERENCE12(),
                item.getREFERENCE13(),
                item.getREFERENCE14(),
                item.getREFERENCE15(),
                1,
                new java.sql.Timestamp(new Date().getTime())
        );
        return oaUser;
    }

    @Override
    public void batchInsertOrganization(List<SBMDMMDMPageInquiryOAStandardOrgInfoSrvOutputItem> itemList) {
        if (!itemList.isEmpty()) {
            List<OaOrganization> organizationList = new ArrayList<>();
            List<OaOrganization> updateList = new ArrayList<>();
            List<String> orgCodeList = itemList.stream().map(SBMDMMDMPageInquiryOAStandardOrgInfoSrvOutputItem::getORGCODE).distinct().collect(Collectors.toList());
            OaOrganizationCriteria criteria = new OaOrganizationCriteria();
            criteria.setOrgCodeList(orgCodeList);
            List<OaOrganization> oldList = oaOrganizationRepository.selectByCriteria(criteria);
            Map<String, OaOrganization> oldMap = LambdaTool.changeCollectionToHashMap(oldList, OaOrganization::getOrgCode);
            for (SBMDMMDMPageInquiryOAStandardOrgInfoSrvOutputItem item : itemList) {
                OaOrganization old = oldMap.get(item.getORGCODE());
                if (old == null) {
                    OaOrganization organization = new OaOrganization(
                            item.getORGCODE(),
                            item.getORGNAME(),
                            item.getPARENTORGID(),
                            item.getDISPLAYORDER(),
                            item.getSTATUS(),
                            item.getORGLEVEL(),
                            item.getREFERENCE1(),
                            item.getREFERENCE2(),
                            item.getREFERENCE3(),
                            item.getREFERENCE4(),
                            item.getREFERENCE5(),
                            item.getREFERENCE6(),
                            item.getREFERENCE7(),
                            item.getREFERENCE8(),
                            item.getREFERENCE9(),
                            item.getREFERENCE10(),
                            item.getREFERENCE11(),
                            item.getREFERENCE12(),
                            item.getREFERENCE13(),
                            item.getREFERENCE14(),
                            item.getREFERENCE15()
                    );
                    organization.setOrgId(SnowFlake.instant().nextId().toString());
                    organization.setLastUpdateTime(organization.getReference1());
                    organizationList.add(organization);
                } else {
                    old.modify(
                            item.getORGCODE(),
                            item.getORGNAME(),
                            item.getPARENTORGID(),
                            item.getDISPLAYORDER(),
                            item.getSTATUS(),
                            item.getORGLEVEL(),
                            item.getREFERENCE1(),
                            item.getREFERENCE2(),
                            item.getREFERENCE3(),
                            item.getREFERENCE4(),
                            item.getREFERENCE5(),
                            item.getREFERENCE6(),
                            item.getREFERENCE7(),
                            item.getREFERENCE8(),
                            item.getREFERENCE9(),
                            item.getREFERENCE10(),
                            item.getREFERENCE11(),
                            item.getREFERENCE12(),
                            item.getREFERENCE13(),
                            item.getREFERENCE14(),
                            item.getREFERENCE15()
                    );
                    updateList.add(old);
                }
            }
            if (CollectionUtils.isNotEmpty(organizationList)) {
                oaOrganizationRepository.batchInsert(organizationList);
            }
            if (CollectionUtils.isNotEmpty(updateList)) {
                oaOrganizationRepository.batchUpdate(updateList);
            }
        }
    }
}
