package com.infoepoch.pms.dispatchassistant.domain.system.uploadFile;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.infoepoch.pms.dispatchassistant.common.component.SnowFlake;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.Date;

/**
* 上传文件记录表
*/
public class UploadFile {

    public String getFullname() {
        return getFileName() + getExtension();
    }

    /**
     * 初始化Id
     */
    public void initializePk() {
        if (StringUtils.isBlank(this.id))
            this.id = String.valueOf(SnowFlake.instant().nextId());
    }
    /**
     * 校验
     */
    public void verify() {
    }

    /**
     * 私有无参构造
     */
    private UploadFile() {
    }

    /**
     * 仓储还原
     */
    public UploadFile(String id, String fileName, String extension, String savePath, Long contentLength, String contentType, Date uploadTime, Boolean hasDimension, BigDecimal width, BigDecimal height, String thumbnalData, String uploadUserId, String uploadUserName, String domainId, String domainType) {
        this.id = id;
        this.fileName = fileName;
        this.extension = extension;
        this.savePath = savePath;
        this.contentLength = contentLength;
        this.contentType = contentType;
        this.uploadTime = uploadTime;
        this.hasDimension = hasDimension;
        this.width = width;
        this.height = height;
        this.thumbnalData = thumbnalData;
        this.uploadUserId = uploadUserId;
        this.uploadUserName = uploadUserName;
        this.domainId = domainId;
        this.domainType = domainType;
    }

    /**
     * 新增
     */
    public UploadFile(String fileName, String extension, String savePath, Long contentLength, String contentType, Boolean hasDimension, BigDecimal width, BigDecimal height, String thumbnalData, String uploadUserId, String uploadUserName, String domainId, String domainType) {
        this.id = SnowFlake.instant().nextId().toString();
        this.fileName = fileName;
        this.extension = extension;
        this.savePath = savePath;
        this.contentLength = contentLength;
        this.contentType = contentType;
        this.uploadTime = new Date();
        this.hasDimension = hasDimension;
        this.width = width;
        this.height = height;
        this.thumbnalData = thumbnalData;
        this.uploadUserId = uploadUserId;
        this.uploadUserName = uploadUserName;
        this.domainId = domainId;
        this.domainType = domainType;
    }

    /**
     * 新增
     */
    public UploadFile(String fileName, String extension, String savePath, Long contentLength, String contentType, Boolean hasDimension, BigDecimal width, BigDecimal height, String thumbnalData, String uploadUserId, String uploadUserName) {
        this.id = SnowFlake.instant().nextId().toString();
        this.fileName = fileName;
        this.extension = extension;
        this.savePath = savePath;
        this.contentLength = contentLength;
        this.contentType = contentType;
        this.uploadTime = new Date();
        this.hasDimension = hasDimension;
        this.width = width;
        this.height = height;
        this.thumbnalData = thumbnalData;
        this.uploadUserId = uploadUserId;
        this.uploadUserName = uploadUserName;
    }

    /**
     * 主键
     */
    private String id;
    /**
     * 文件名称
     */
    private String fileName;
    /**
     * 后缀
     */
    private String extension;
    /**
     * 相对保存路径
     */
    private String savePath;
    /**
     * 文件大小
     */
    private Long contentLength;
    /**
     * 文件类型
     */
    private String contentType;
    /**
     * 上传时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss" ,timezone = "GMT+8")
    private Date uploadTime;
    /**
     * 是否有尺寸，只有图片文件可以计算尺寸
     */
    private Boolean hasDimension;
    /**
     * 宽
     */
    private BigDecimal width;
    /**
     * 高
     */
    private BigDecimal height;
    /**
     * 缩略图信息序列化数据
     */
    private String thumbnalData;
    /**
     * 文件上传者ID
     */
    private String uploadUserId;
    /**
     * 文件上传者姓名
     */
    private String uploadUserName;
    /**
     * 关联领域ID
     */
    private String domainId;
    /**
     * 关联单据类型
     */
    private String domainType;

    public String getId() {
        return id;
    }

    public String getFileName() {
        return fileName;
    }

    public String getExtension() {
        return extension;
    }

    public String getSavePath() {
        return savePath;
    }

    public Long getContentLength() {
        return contentLength;
    }

    public String getContentType() {
        return contentType;
    }

    public Date getUploadTime() {
        return uploadTime;
    }

    public Boolean getHasDimension() {
        return hasDimension != null && hasDimension;
    }

    public BigDecimal getWidth() {
        return width;
    }

    public BigDecimal getHeight() {
        return height;
    }

    public String getThumbnalData() {
        return thumbnalData == null ? "" : thumbnalData;
    }

    public String getUploadUserId() {
        return uploadUserId;
    }

    public String getUploadUserName() {
        return uploadUserName;
    }

    public String getDomainId() {
        return domainId;
    }

    public String getDomainType() {
        return domainType;
    }

}