package com.infoepoch.pms.dispatchassistant.domain.system.dict;

import java.util.List;

public interface IDictTypeRepository {

    /**
     * 条件查询列表数据
     *
     * @param criteria
     * @return
     */
    List<SystemDictType> selectByCriteria(SystemDictCriteria criteria);

    /**
     * 条件查询列表数量
     *
     * @param criteria
     * @return
     */
    int selectByCriteriaCount(SystemDictCriteria criteria);

    /**
     * 根据ID获取字典详情
     *
     * @param id
     * @return
     */
    SystemDictType selectById(String id);

    /**
     * 根据字典类别查询
     *
     * @param dictType
     * @return
     */
    SystemDictType selectByType(String dictType);

    /**
     * 插入
     *
     * @param dictType
     */
    void insert(SystemDictType dictType);

    /**
     * 更新
     *
     * @param dictType
     */
    void update(SystemDictType dictType);

    /**
     * 软删除
     *
     * @param id
     */
    void softDeleteById(String id);

    /**
     * 删除
     *
     * @param id
     */
    void deleteById(String id);
}
