package com.infoepoch.pms.dispatchassistant.domain.langchain.chat.knowledgeBaseChat;



import com.infoepoch.pms.dispatchassistant.common.exception.ValidationException;
import com.infoepoch.pms.dispatchassistant.domain.langchain.chat.ChatBaseRequest;
import com.infoepoch.pms.dispatchassistant.domain.langchain.chat.History;
import io.micrometer.core.instrument.util.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KnowledgeBaseChatRequest extends ChatBaseRequest {

    /**
     * 添加历史记录
     *
     * @param role
     * @param content
     */
    public void addHistory(String role, String content) {
        if (StringUtils.isBlank(role))
            throw new ValidationException("角色不可为空");
        if (StringUtils.isBlank(content))
            throw new ValidationException("内容不可为空");
        if (this.history == null)
            this.history = new ArrayList<>();
        History history = new History(
                role,
                content
        );
        this.history.add(history);
    }

    /**
     * 校验
     */
    public void verify() {
        // 查询语句不可为空
        if (StringUtils.isBlank(this.query))
            throw new ValidationException("查询语句不可为空");
        if (StringUtils.isBlank(this.knowledgeBaseName))
            throw new ValidationException("知识库名称不可为空");
        if (this.topK == null)
            throw new ValidationException("topK不可为空");
        if (this.scoreThreshold == null)
            throw new ValidationException("scoreThreshold不可为空");
        // 历史记录如果为null则置为空列表
        if (this.history == null) {
            this.history = new ArrayList<>();
        }
        if (this.stream == null)
            this.stream = false;
        if (this.modelName == null || this.modelName.isEmpty())
            throw new ValidationException("模型名称不可为空");
        if (this.temperature == null)
            throw new ValidationException("temperature不可为空");
        if (this.maxTokens == null)
            throw new ValidationException("最大字数不可为空");
        if (this.promptName == null || this.promptName.isEmpty())
            throw new ValidationException("提示词名称不可为空");
    }

    /**
     * 转换为请求MAP
     *
     * @return
     */
    public Map<String, Object> toMap() {
        this.verify();
        Map<String, Object> map = new HashMap<>();
        map.put("query", this.query);
        map.put("knowledge_base_name", this.knowledgeBaseName);
        map.put("top_k", this.topK);
        map.put("score_threshold", this.scoreThreshold);
        map.put("history", this.history);
        map.put("stream", this.stream);
        map.put("model_name", this.modelName);
        map.put("temperature", this.temperature);
        map.put("max_tokens", this.maxTokens);
        map.put("prompt_name", this.promptName);
        return map;
    }

    /**
     * 私有化无参构造
     */
    private KnowledgeBaseChatRequest() {
    }

    /**
     * 新增
     *
     * @param query
     * @param knowledgeBaseName
     * @param topK
     * @param scoreThreshold
     * @param stream
     * @param modelName
     * @param temperature
     * @param maxTokens
     * @param promptName
     */
    public KnowledgeBaseChatRequest(String query, String knowledgeBaseName, Integer topK, Integer scoreThreshold, Boolean stream, String modelName, BigDecimal temperature, Integer maxTokens, String promptName) {
        this.query = query;
        this.knowledgeBaseName = knowledgeBaseName;
        this.topK = topK;
        this.scoreThreshold = scoreThreshold;
        this.stream = stream;
        this.modelName = modelName;
        this.temperature = temperature;
        this.maxTokens = maxTokens;
        this.promptName = promptName;
    }

    /**
     * 查询语句
     */
    private String query;
    /**
     * 知识库名称
     */
    private String knowledgeBaseName;
    /**
     *
     */
    private Integer topK;
    /**
     *
     */
    private Integer scoreThreshold;
    /**
     * 历史记录
     */
    private List<History> history;
    /**
     * 是否启用流式输出
     */
    private Boolean stream;
    /**
     * 模型名称
     */
    private String modelName;
    /**
     *
     */
    private BigDecimal temperature;
    /**
     * 最大字数
     */
    private Integer maxTokens;
    /**
     * 提示词名称
     */
    private String promptName;

    public String getQuery() {
        return query;
    }

    public String getKnowledgeBaseName() {
        return knowledgeBaseName;
    }

    public Integer getTopK() {
        return topK;
    }

    public Integer getScoreThreshold() {
        return scoreThreshold;
    }

    public List<History> getHistory() {
        return history;
    }

    public Boolean getStream() {
        return stream;
    }

    public String getModelName() {
        return modelName;
    }

    public BigDecimal getTemperature() {
        return temperature;
    }

    public Integer getMaxTokens() {
        return maxTokens;
    }

    public String getPromptName() {
        return promptName;
    }
}
