package com.infoepoch.pms.dispatchassistant.domain.basic.todo;

import java.util.List;

/**
 * 待办IRepository
 */
public interface ITodoRepository {

    /**
     * 插入
     */
    void insert(Todo todo);

    /**
     * 更新
     * @param todo
     */
    void update(Todo todo);

    /**
     * 更新
     */
    void updateAction(Todo todo);

    /**
     * 批量更新
     */
    int[] batchUpdate(List<Todo> todoList);

    /**
     *
     * @param id
     */
    void deleteById(String id);

    /**
     * 根据id查询
     */
    Todo selectById(String id);

    /**
     * 根据流程查询
     */
    List<Todo> selectByProcess(String processId);

    /**
     * 查询所有单据类型
     */
    List<String> selectDocumentTypes();

    //-------------------------------------------------------------------------

    /**
     * 查询数量
     */
    int selectCount(TodoCriteria criteria);

    /**
     * 分页查询
     */
    List<Todo> selectByPage(int pageIndex, int pageSize, TodoCriteria criteria);

    /**
     * 查询
     */
    List<Todo> selectByCriteria(TodoCriteria criteria);

    //待阅更新为已阅
    void read(String todoId);

}